% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grbase-utilities.R
\name{grbase-utilities}
\alias{grbase-utilities}
\alias{rhsFormula2list}
\alias{matrix2list}
\alias{rowmat2list}
\alias{colmat2list}
\alias{pairs2num}
\alias{rhsf2list}
\alias{rhsf2vec}
\alias{listify_dots}
\alias{list2rhsFormula}
\alias{list2rhsf}
\alias{which.arr.index}
\alias{which_matrix_index}
\alias{rowSumsPrim}
\alias{colSumsPrim}
\alias{colwiseProd}
\alias{lapplyV2I}
\alias{lapplyI2V}
\title{gRbase utilities}
\usage{
rhsFormula2list(form)

rhsf2list(form)

rhsf2vec(form)

listify_dots(dots)

list2rhsFormula(form)

list2rhsf(form)

rowmat2list(X)

colmat2list(X)

matrix2list(X, byrow = TRUE)

which.arr.index(X)

which_matrix_index(X)

rowSumsPrim(X)

colSumsPrim(X)

colwiseProd(v, X)

lapplyV2I(setlist, item)

lapplyI2V(setlist, item)
}
\arguments{
\item{form}{Formula specification (a right-hand sided formula, a
numeric/character vector or a list of vectors).}

\item{dots}{dot-arguments to be turned into a list}

\item{X}{A matrix.}

\item{byrow}{Should the split be by row or by column.}

\item{v}{A vector.}

\item{setlist}{A list of atomic vectors}

\item{item}{An atomic vector}
}
\description{
Various utility functions for gRbase. Includes 'faster
versions' of certain standard R functions.
}
\details{
\code{which.arr.ind}: Returns matrix n x 2 matrix with
indices of non-zero entries in matrix \code{X}. Notice
\code{which_matrix_index__} is cpp implementation.

\code{colwiseProd}: multiplies a vector v and a matrix X
columnwise (as opposed to rowwise which is achieved by
\code{v * X}). Hence \code{colwiseProd} does the same as
\code{t(v * t(X))} - but it does so faster for numeric values.

\itemize{
\item lapplyV2I: same as but much faster than \code{lapply(setlist, function(elt) match(elt, item))}
\item lapplyI2V: same as but faster than \code{lapply(setlist, function(elt) item[elt])}
}
}
\examples{
## colwiseProd
X <- matrix(1:16, nrow=4)
v <- 1:4
t(v * t(X))
colwiseProd(v, X)
\dontrun{
system.time(for (ii in 1:100000)  t(v * t(X)))
system.time(for (ii in 1:100000)  colwiseProd(v, X))
}


setlist <- list(c(1,2,3), c(2,3,4), c(2,4,5))
item <- c(2,3)

lapplyV2I(setlist, item)
lapply(setlist, function(gg) match(gg, item))

lapplyI2V(setlist, item)
lapply(setlist, function(x) item[x])

if (require(microbenchmark)){
microbenchmark(
  lapplyV2I(setlist, item),
  lapply(setlist, function(elt) match(elt, item)))

microbenchmark::microbenchmark(
  lapplyI2V(setlist, item),
  lapply(setlist, function(elt) item[elt]))
}
}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
