% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_taxa.R
\name{select_taxa}
\alias{select_taxa}
\title{Taxon information}
\usage{
select_taxa(query, children = FALSE, counts = FALSE)
}
\arguments{
\item{query}{\code{string}: A vector containing one or more search terms,
given as strings. Search terms can be scientific or common names, or
taxanomic identifiers. If greater control is required to disambiguate search
terms, taxonomic levels can be provided explicitly via a named \code{list}
for a single name, or a \code{data.frame} for multiple names (see examples).
Note that searches are not case-sensitive.}

\item{children}{\code{logical}: return child concepts for the provided
query?}

\item{counts}{\code{logical}: return occurrence counts for all taxa
found? \code{FALSE} by default}
}
\value{
A \code{data.frame} of taxonomic information.
}
\description{
In the ALA, all records are associated with an identifier that uniquely
identifies the taxon to which that record belongs. However, taxonomic names
are often ambiguous due to homonymy; i.e. re-use of names (common or
scientific) in different clades. Hence, \code{select_taxa} provides a means
to search for taxonomic names and check the results are 'correct' before
proceeded to download data via \code{\link{ala_occurrences}()},
\code{\link{ala_species}()} or \code{\link{ala_counts}()}. The resulting
\code{data.frame} of taxonomic information can be passed directly to
\code{ala_} functions to filter records to the specified taxon or taxa.
}
\examples{
\dontrun{
# Search using a single term
select_taxa("Reptilia")
# or equivalently:
select_taxa("reptilia") # not case sensitive

# Search with multiple ranks. This is required if a single term is a homonym.
select_taxa(
  list(kingdom = "Plantae", genus = "Microseris"),
  children = TRUE,
  counts = TRUE)

# As above, but for multiple searches at once.
select_taxa(
   data.frame(
     genus = c("microseris", "Eucalyptus"),
     kingdom = "plantae"))

# Search using an unique taxon identifier
select_taxa(query = "https://id.biodiversity.org.au/node/apni/2914510")

# Search multiple taxa
select_taxa(c("reptilia", "mammalia")) # returns one row per taxon
}
}
\seealso{
\code{\link{select_columns}}, \code{\link{select_filters}} and
\code{\link{select_locations}} for other ways to restrict the information returned
by \code{\link{ala_occurrences}} and related functions.
}
