% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atlas_species.R
\name{atlas_species}
\alias{atlas_species}
\title{Return species lists}
\usage{
atlas_species(
  request = NULL,
  identify = NULL,
  filter = NULL,
  geolocate = NULL,
  refresh_cache = FALSE
)
}
\arguments{
\item{request}{optional \code{data_rquest} object: generated by a call to
\code{\link[=galah_call]{galah_call()}}.}

\item{identify}{\code{data.frame}: generated by a call to
\code{\link[=galah_identify]{galah_identify()}}.}

\item{filter}{\code{data.frame}: generated by a call to
\code{\link[=galah_filter]{galah_filter()}}}

\item{geolocate}{\code{string}: generated by a call to
\code{\link[=galah_geolocate]{galah_geolocate()}}}

\item{refresh_cache}{\code{logical}: if set to \code{TRUE} and
\code{galah_config(caching = TRUE)} then files cached from a previous query will
be replaced by the current query}
}
\value{
An object of class \code{tbl_df} and \code{data.frame} (aka a tibble),
returning matching species The \code{data.frame} object has attributes listing of
the user-supplied arguments of the \code{data_request}
(i.e., identify, filter, geolocate, columns)
}
\description{
While there are reasons why users may need to check every record meeting their
search criteria (i.e. using \code{\link[=atlas_occurrences]{atlas_occurrences()}}), a common use case
is to simply identify which species occur in a specified region, time period,
or taxonomic group. This function returns a \code{data.frame} with one row
per species, and columns giving associated taxonomic information.
}
\details{
The primary use case of this function is to extract species-level information
given a set of criteria defined by \code{\link[=search_taxa]{search_taxa()}},
\code{\link[=galah_filter]{galah_filter()}} or \code{\link[=galah_geolocate]{galah_geolocate()}}. If the purpose
is simply to get taxonomic information that is not restricted by filtering,
then \code{\link[=search_taxa]{search_taxa()}} is more efficient. Similarly, if counts are
required that include filter but without returning taxonomic detail, then
\code{\link[=atlas_counts]{atlas_counts()}} is more efficient (see examples).
}
\section{Examples}{


First, look up a genus of interest in the ALA with \code{\link[=search_taxa]{search_taxa()}}\if{html}{\out{<div class="sourceCode r">}}\preformatted{search_taxa("Heleioporus")
#> # A tibble: 1 x 13
#>   search_term scientific_name scientific_name_~ taxon_concept_id   rank  match_type kingdom phylum class order family genus
#>   <chr>       <chr>           <chr>             <chr>              <chr> <chr>      <chr>   <chr>  <chr> <chr> <chr>  <chr>
#> 1 Heleioporus Heleioporus     Gray, 1841        urn:lsid:biodiver~ genus exactMatch Animal~ Chord~ Amph~ Anura Limno~ Hele~
#> # ... with 1 more variable: issues <chr>
}\if{html}{\out{</div>}}

It's a good idea to find how many species there are for the taxon you are
interested in - in our case, genus \emph{Heleioporus} - with \code{\link[=atlas_counts]{atlas_counts()}}\if{html}{\out{<div class="sourceCode r">}}\preformatted{galah_call() |>
  galah_identify("Heleioporus") |>
  atlas_counts(type = "species")
#> # A tibble: 1 x 1
#>   count
#>   <int>
#> 1     6
}\if{html}{\out{</div>}}

Now get taxonomic information on all species within this genus with
\code{atlas_species()}\if{html}{\out{<div class="sourceCode r">}}\preformatted{# (every row is a species with associated taxonomic data)
galah_call() |>
  galah_identify("Heleioporus") |>
  atlas_species()
#> # A tibble: 6 x 10
#>   kingdom  phylum   class    order family          genus       species     author    species_guid           vernacular_name
#>   <chr>    <chr>    <chr>    <chr> <chr>           <chr>       <chr>       <chr>     <chr>                  <chr>          
#> 1 Animalia Chordata Amphibia Anura Limnodynastidae Heleioporus Heleioporu~ (Gray, 1~ urn:lsid:biodiversity~ Moaning Frog   
#> 2 Animalia Chordata Amphibia Anura Limnodynastidae Heleioporus Heleioporu~ (Shaw & ~ urn:lsid:biodiversity~ Giant Burrowin~
#> 3 Animalia Chordata Amphibia Anura Limnodynastidae Heleioporus Heleioporu~ Gray, 18~ urn:lsid:biodiversity~ Western Spotte~
#> 4 Animalia Chordata Amphibia Anura Limnodynastidae Heleioporus Heleioporu~ (Lee & M~ urn:lsid:biodiversity~ Sand Frog      
#> 5 Animalia Chordata Amphibia Anura Limnodynastidae Heleioporus Heleioporu~ (Lee & M~ urn:lsid:biodiversity~ Plains Frog    
#> 6 Animalia Chordata Amphibia Anura Limnodynastidae Heleioporus Heleioporu~ Lee, 1967 urn:lsid:biodiversity~ Western Marsh ~
}\if{html}{\out{</div>}}

You can also get taxonomic information on species by piping with \verb{\%>\%} or
\verb{|>}. Just begin your query with \code{\link[=galah_call]{galah_call()}}\if{html}{\out{<div class="sourceCode r">}}\preformatted{galah_call() |>
  galah_identify("Heleioporus") |>
  atlas_species()
#> # A tibble: 6 x 10
#>   kingdom  phylum   class    order family          genus       species     author    species_guid           vernacular_name
#>   <chr>    <chr>    <chr>    <chr> <chr>           <chr>       <chr>       <chr>     <chr>                  <chr>          
#> 1 Animalia Chordata Amphibia Anura Limnodynastidae Heleioporus Heleioporu~ (Gray, 1~ urn:lsid:biodiversity~ Moaning Frog   
#> 2 Animalia Chordata Amphibia Anura Limnodynastidae Heleioporus Heleioporu~ (Shaw & ~ urn:lsid:biodiversity~ Giant Burrowin~
#> 3 Animalia Chordata Amphibia Anura Limnodynastidae Heleioporus Heleioporu~ Gray, 18~ urn:lsid:biodiversity~ Western Spotte~
#> 4 Animalia Chordata Amphibia Anura Limnodynastidae Heleioporus Heleioporu~ (Lee & M~ urn:lsid:biodiversity~ Sand Frog      
#> 5 Animalia Chordata Amphibia Anura Limnodynastidae Heleioporus Heleioporu~ (Lee & M~ urn:lsid:biodiversity~ Plains Frog    
#> 6 Animalia Chordata Amphibia Anura Limnodynastidae Heleioporus Heleioporu~ Lee, 1967 urn:lsid:biodiversity~ Western Marsh ~
}\if{html}{\out{</div>}}
}

