% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/galah_filter.R
\name{galah_filter}
\alias{galah_filter}
\title{Narrow a query by specifying filters}
\usage{
galah_filter(..., profile = NULL)
}
\arguments{
\item{...}{filters, in the form \verb{field logical value}}

\item{profile}{\code{string}: (optional) a data quality profile to apply to the
records. See \code{\link[=show_all_profiles]{show_all_profiles()}} for valid profiles. By default
no profile is applied.}
}
\value{
An object of class \code{data.frame} and \code{galah_filter},
containing filter values.
}
\description{
'filters' are arguments of the form \verb{field logical value} that are used
to narrow down the number of records returned by a specific query.
For example, it is common for users to request records from a particular year
(\code{year == 2020}), or to return all records except for fossils
(\code{basisOfRecord != "FossilSpecimen"}).
The result of \code{galah_filter} can be passed to the \code{filters}
argument in \code{\link[=atlas_occurrences]{atlas_occurrences()}}, \code{\link[=atlas_species]{atlas_species()}} or
\code{\link[=atlas_counts]{atlas_counts()}}. \code{galah_filter} uses non-standard evaluation (NSE),
and is designed to be as compatible as possible with \code{dplyr::filter}
syntax.
}
\details{
All statements passed to \code{galah_filter()} (except the \code{profile}
argument) take the form of field - logical - value. Permissible examples include:
\itemize{
\item \code{=} or \code{==} (e.g. \code{year = 2020})
\item \code{!=}, e.g. \code{year != 2020})
\item \code{>} or \code{>=} (e.g. \code{year >= 2020})
\item \code{<} or \code{<=} (e.g. \code{year <= 2020})
\item \code{OR} statements (e.g. \code{year == 2018 | year == 2020})
\item \code{AND} statements (e.g. \code{year >= 2000 & year <= 2020})
}

In some cases \code{R} will fail to parse inputs with a single equals sign
(\code{=}), particularly where statements are separated by \code{&} or
\code{|}. This problem can be avoided by using a double-equals (\code{==}) instead.
}
\section{Examples}{


Create a custom filter for records of interest\if{html}{\out{<div class="sourceCode r">}}\preformatted{filters <- galah_filter(
    basisOfRecord == "HumanObservation",
    year >= 2010,
    stateProvince == "New South Wales")
}\if{html}{\out{</div>}}

Add the default ALA data quality profile\if{html}{\out{<div class="sourceCode r">}}\preformatted{filters <- galah_filter(
    basisOfRecord == "HumanObservation",
    year >= 2020,
    stateProvince == "New South Wales",
    profile = "ALA")
}\if{html}{\out{</div>}}

Use filters to exclude particular values\if{html}{\out{<div class="sourceCode r">}}\preformatted{filter <- galah_filter(year >= 2010 & year != 2021)

atlas_counts(filter = filter)
#> # A tibble: 1 x 1
#>      count
#>      <int>
#> 1 43916661
}\if{html}{\out{</div>}}

Separating statements with a comma is equivalent to an \code{AND} statement\if{html}{\out{<div class="sourceCode r">}}\preformatted{galah_filter(year >= 2010 & year < 2020) # is the same as:
galah_filter(year >= 2010, year < 2020)
}\if{html}{\out{</div>}}

All statements must include the field name\if{html}{\out{<div class="sourceCode r">}}\preformatted{galah_filter(year == 2010 | year == 2021) # this works (note double equals)
galah_filter(year == c(2010, 2021)) # same as above 
galah_filter(year == 2010 | 2021) # this fails
}\if{html}{\out{</div>}}

It is possible to use an object to specify required values\if{html}{\out{<div class="sourceCode r">}}\preformatted{# Numeric example

year_value <- 2010

galah_call() \%>\%
  galah_filter(year > year_value) \%>\%
  atlas_counts()
#> # A tibble: 1 x 1
#>      count
#>      <int>
#> 1 42816943
}\if{html}{\out{</div>}}\if{html}{\out{<div class="sourceCode r">}}\preformatted{# Categorical example

basis_of_record <- c("HumanObservation", "MaterialSample")

galah_call() \%>\%
  galah_filter(basisOfRecord == basis_of_record) \%>\%
  atlas_counts()
#> # A tibble: 1 x 1
#>      count
#>      <int>
#> 1 82809464
}\if{html}{\out{</div>}}

\code{solr} supports range queries on text as well as numbers. The following
queries all Australian States and Territories alphabetically after "Tasmania"\if{html}{\out{<div class="sourceCode r">}}\preformatted{galah_call() \%>\%
  galah_filter(cl22 >= "Tasmania") \%>\%
  atlas_counts()
#> # A tibble: 1 x 1
#>      count
#>      <int>
#> 1 30230213
}\if{html}{\out{</div>}}
}

\seealso{
\code{\link[=search_taxa]{search_taxa()}} and \code{\link[=galah_geolocate]{galah_geolocate()}} for other ways to restrict
the information returned by \code{\link[=atlas_occurrences]{atlas_occurrences()}} and related functions. Use
\code{\link[=search_fields]{search_fields()}} to find fields that
you can filter by, and \code{\link[=search_field_values]{search_field_values()}} to find what values
of those filters are available.
}
