% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atlas_species.R
\name{atlas_species}
\alias{atlas_species}
\title{Return species lists}
\usage{
atlas_species(
  request = NULL,
  identify = NULL,
  filter = NULL,
  geolocate = NULL,
  data_profile = NULL,
  refresh_cache = FALSE
)
}
\arguments{
\item{request}{optional \code{data_request} object: generated by a call to
\code{\link[=galah_call]{galah_call()}}.}

\item{identify}{\code{data.frame}: generated by a call to
\code{\link[=galah_identify]{galah_identify()}}.}

\item{filter}{\code{data.frame}: generated by a call to
\code{\link[=galah_filter]{galah_filter()}}}

\item{geolocate}{\code{string}: generated by a call to
\code{\link[=galah_geolocate]{galah_geolocate()}}}

\item{data_profile}{\code{string}: generated by a call to
\code{\link[=galah_apply_profile]{galah_apply_profile()}}}

\item{refresh_cache}{\code{logical}: if set to \code{TRUE} and
\code{galah_config(caching = TRUE)} then files cached from a previous query will
be replaced by the current query}
}
\value{
An object of class \code{tbl_df} and \code{data.frame} (aka a tibble),
returning matching species The \code{data.frame} object has attributes listing of
the user-supplied arguments of the \code{data_request}
(i.e., identify, filter, geolocate, columns)
}
\description{
While there are reasons why users may need to check every record meeting their
search criteria (i.e. using \code{\link[=atlas_occurrences]{atlas_occurrences()}}), a common use case
is to simply identify which species occur in a specified region, time period,
or taxonomic group. This function returns a \code{data.frame} with one row
per species, and columns giving associated taxonomic information.
}
\details{
The primary use case of this function is to extract species-level information
given a set of criteria defined by \code{\link[=search_taxa]{search_taxa()}},
\code{\link[=galah_filter]{galah_filter()}} or \code{\link[=galah_geolocate]{galah_geolocate()}}. If the purpose
is simply to get taxonomic information that is not restricted by filtering,
then \code{\link[=search_taxa]{search_taxa()}} is more efficient. Similarly, if counts are
required that include filter but without returning taxonomic detail, then
\code{\link[=atlas_counts]{atlas_counts()}} is more efficient (see examples).
}
\section{Examples}{


First, look up a genus of interest in the ALA with \code{\link[=search_taxa]{search_taxa()}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{search_taxa("Heleioporus")
#> # A tibble: 1 x 13
#>   search_term scienti~1 scien~2 taxon~3 rank  match~4 kingdom phylum class order
#>   <chr>       <chr>     <chr>   <chr>   <chr> <chr>   <chr>   <chr>  <chr> <chr>
#> 1 Heleioporus Heleiopo~ Gray, ~ https:~ genus exactM~ Animal~ Chord~ Amph~ Anura
#> # ... with 3 more variables: family <chr>, genus <chr>, issues <chr>, and
#> #   abbreviated variable names 1: scientific_name,
#> #   2: scientific_name_authorship, 3: taxon_concept_id, 4: match_type
}\if{html}{\out{</div>}}

It's a good idea to find how many species there are for the taxon you are
interested in - in our case, genus \emph{Heleioporus} - with \code{\link[=atlas_counts]{atlas_counts()}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{galah_call() |>
  galah_identify("Heleioporus") |>
  atlas_counts(type = "species")
#> # A tibble: 1 x 1
#>   count
#>   <int>
#> 1     6
}\if{html}{\out{</div>}}

Now get taxonomic information on all species within this genus with
\code{atlas_species()}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# (every row is a species with associated taxonomic data)
galah_call() |>
  galah_identify("Heleioporus") |>
  atlas_species()
#> # A tibble: 6 x 10
#>   kingdom  phylum   class    order family   genus species author speci~1 verna~2
#>   <chr>    <chr>    <chr>    <chr> <chr>    <chr> <chr>   <chr>  <chr>   <chr>  
#> 1 Animalia Chordata Amphibia Anura Limnody~ Hele~ Heleio~ (Gray~ https:~ Moanin~
#> 2 Animalia Chordata Amphibia Anura Limnody~ Hele~ Heleio~ (Shaw~ https:~ Giant ~
#> 3 Animalia Chordata Amphibia Anura Limnody~ Hele~ Heleio~ Gray,~ https:~ Wester~
#> 4 Animalia Chordata Amphibia Anura Limnody~ Hele~ Heleio~ (Lee ~ https:~ Sand F~
#> 5 Animalia Chordata Amphibia Anura Limnody~ Hele~ Heleio~ (Lee ~ https:~ Plains~
#> 6 Animalia Chordata Amphibia Anura Limnody~ Hele~ Heleio~ Lee, ~ https:~ Wester~
#> # ... with abbreviated variable names 1: species_guid, 2: vernacular_name
}\if{html}{\out{</div>}}

You can also get taxonomic information on species by piping with \verb{\%>\%} or
\verb{|>}. Just begin your query with \code{\link[=galah_call]{galah_call()}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{galah_call() |>
  galah_identify("Heleioporus") |>
  atlas_species()
#> # A tibble: 6 x 10
#>   kingdom  phylum   class    order family   genus species author speci~1 verna~2
#>   <chr>    <chr>    <chr>    <chr> <chr>    <chr> <chr>   <chr>  <chr>   <chr>  
#> 1 Animalia Chordata Amphibia Anura Limnody~ Hele~ Heleio~ (Gray~ https:~ Moanin~
#> 2 Animalia Chordata Amphibia Anura Limnody~ Hele~ Heleio~ (Shaw~ https:~ Giant ~
#> 3 Animalia Chordata Amphibia Anura Limnody~ Hele~ Heleio~ Gray,~ https:~ Wester~
#> 4 Animalia Chordata Amphibia Anura Limnody~ Hele~ Heleio~ (Lee ~ https:~ Sand F~
#> 5 Animalia Chordata Amphibia Anura Limnody~ Hele~ Heleio~ (Lee ~ https:~ Plains~
#> 6 Animalia Chordata Amphibia Anura Limnody~ Hele~ Heleio~ Lee, ~ https:~ Wester~
#> # ... with abbreviated variable names 1: species_guid, 2: vernacular_name
}\if{html}{\out{</div>}}
}

