% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_taxa.R
\name{search_taxa}
\alias{search_taxa}
\title{Look up taxon information}
\usage{
search_taxa(...)
}
\arguments{
\item{...}{: A string of one or more scientific names, separated by commas,
or a data frame specifying taxonomic levels. Note that searches are not
case-sensitive.}
}
\value{
An object of class \code{tbl_df}, \code{data.frame} (aka a tibble) and \code{ala_id}
containing taxonomic information.
}
\description{
Look up taxonomic names before downloading
data from the ALA, using \code{\link[=atlas_occurrences]{atlas_occurrences()}}, \code{\link[=atlas_species]{atlas_species()}} or
\code{\link[=atlas_counts]{atlas_counts()}}. Taxon information returned by \code{search_taxa()} may be
passed to \code{\link[=galah_identify]{galah_identify()}} to provide the \code{identify} argument of
\code{atlas_} functions. \code{search_taxa()} allows users to disambiguate homonyms
(i.e. where the same name refers to taxa in different clades) prior to
downloading data.
}
\details{
Users can also specify taxonomic levels in a search using a data frame
(tibble). Taxa may be specified using either the \code{specificEpithet} argument
to designate the second element of a Latin binomial,
or the \code{scientificName} argument to specify the
scientific name (which may include the subspecific epithet if required).
}
\examples{
# Search using a single string. 
# Note that `search_taxa()` isn't case sensitive
search_taxa("Reptilia")

# Search using multiple strings. 
# `search_taxa()` will return one row per taxon
search_taxa("reptilia", "mammalia")

# Specify taxonomic levels in a tibble using "specificEpiphet"
search_taxa(tibble::tibble(
  class = "aves", 
  family = "pardalotidae", 
  genus = "pardalotus", 
  specificEpithet = "punctatus"))

# Specify taxonomic levels in a tibble using "scientificName"                    
search_taxa(tibble::tibble(
  family = c("pardalotidae", "maluridae"), 
  scientificName = c("Pardalotus striatus striatus", "malurus cyaneus")))

# `galah_identify()` uses `search_taxa()` to narrow data queries
taxa <- search_taxa("reptilia", "mammalia")
galah_call() |>
  galah_identify(taxa) |>
  atlas_counts()

}
\seealso{
\code{\link[=search_identifiers]{search_identifiers()}} for how to get names if taxonomic identifiers
are already known. \code{\link[=galah_identify]{galah_identify()}}, \code{\link[=galah_select]{galah_select()}}, \code{\link[=galah_filter]{galah_filter()}}, and
\code{\link[=galah_geolocate]{galah_geolocate()}} for ways to restrict the information returned by
\code{\link[=atlas_occurrences]{atlas_occurrences()}} and related functions. \code{\link[=atlas_taxonomy]{atlas_taxonomy()}} to look
up taxonomic trees.
}
