\name{latexTable}
\alias{latexTable}
\title{LaTeX table for strategic models}
\usage{latexTable(x, digits=max(3, getOption("digits") - 2), scientific=NA, blankfill="",
    math.style.negative=TRUE, file="", floatplace="htbp", rowsep=2,
    useboot=TRUE)
}
\description{Makes a LaTeX table of strategic model results.}
\details{\code{latexTable} prints LaTeX code for the presentation of results from a
strategic model.  Each row contains one regressor, and each column contains
one of the utility (or variance term) equations in the model.  For example,
in a model fit with \code{\link{egame12}}, the four columns will be u11,
u13, u14, and u24 respectively.  Each cell contains the estimated parameter,
atop its standard error in parentheses.  Cells that are empty because a
regressor is not included in a particular equation are filled with the
string specified in the option \code{blankfill}.  Signorino and Tarar (2006,
p. 593) contains a table of this variety.

The table generated depends on the \pkg{multirow} package for LaTeX, so
make sure to include \code{\\usepackage{multirow}} in the preamble of your
document.

The \code{digits} option does not yet work seamlessly; you may have to
resort to trial and error.}
\value{\code{x}, invisibly.}
\references{Curtis S. Signorino and Ahmer Tarar.  2006.  \dQuote{A Unified
Theory and Test of Extended Immediate Deterrence.}  \emph{American Journal
of Political Science} 50(3):586--605.}
\author{Brenton Kenkel (\email{brenton.kenkel@gmail.com})}
\arguments{\item{x}{a fitted model of class \code{game}.}
\item{digits}{number of digits to print.}
\item{scientific}{logical or integer value to control use of scientific
notation.  See \code{\link{format}}.}
\item{blankfill}{text to fill empty cells (those where a certain variable
did not enter the given equation).}
\item{math.style.negative}{whether negative signs should be "math style" or
plain hyphens.  Defaults to \code{TRUE}.}
\item{file}{file to save the output in.  Defaults to \code{""}, which prints
the table to the R console.}
\item{floatplace}{where to place the table float; e.g., for
\code{\\begin\{table\}[htp]}, use \code{floatplace = "htp"}.}
\item{rowsep}{amount of space (in points) to put between rows.}
\item{useboot}{logical: use bootstrap estimates (if available) to calculate
standard errors?}
}
\examples{data(war1800)
f1 <- esc + war ~ s_wt_re1 + revis1 | 0 | balanc + revis1 | balanc
m1 <- egame12(f1, data = war1800)

latexTable(m1)
latexTable(m1, digits = 8)
latexTable(m1, blankfill = "--")  ## dashes in blank cells

\dontrun{
latexTable(m1, file = "my_table.tex")  ## write to file}}

