% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.gamsel.R
\name{summary.gamsel}
\alias{summary.gamsel}
\title{Gamsel summary routine}
\usage{
\method{summary}{gamsel}(object, label = FALSE, ...)
}
\arguments{
\item{object}{\code{gamsel} object}

\item{label}{if \code{TRUE}, annotate the plot with variable labels. Default
is \code{FALSE}}

\item{\dots}{additional arguments to summary}
}
\value{
Nothing is returned.
}
\description{
This makes a two-panel plot of the gamsel object.
}
\details{
A two panel plot is produced, that summarizes the linear components and the
nonlinear components, as a function of lambda. For the linear components, it
is the coefficient for each variable. For the nonlinear, we see the norm of
the nonlinear coefficients.
}
\examples{

##data=gamsel:::gendata(n=500,p=12,k.lin=3,k.nonlin=3,deg=8,sigma=0.5)
data = readRDS(system.file("extdata/gamsel_example.RDS", package = "gamsel"))
attach(data)
bases=pseudo.bases(X,degree=10,df=6)
# Gaussian gam
gamsel.out=gamsel(X,y,bases=bases)
par(mfrow=c(1,2),mar=c(5,4,3,1))
summary(gamsel.out)

}
\references{
Chouldechova, A. and Hastie, T. (2015) \emph{Generalized
Additive Model Selection}
}
\seealso{
\code{gamsel}, and methods \code{plot}, \code{print} and
\code{predict} for \code{cv.gamsel} object.
}
\author{
Alexandra Chouldechova and Trevor Hastie\cr Maintainer: Trevor
Hastie \email{hastie@stanford.edu}
}
\keyword{nonparametric}
\keyword{regression}
\keyword{smooth}
