% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.gamsel.R
\name{cv.gamsel}
\alias{cv.gamsel}
\title{Cross-validation Routine for Gamsel}
\usage{
cv.gamsel(
  x,
  y,
  lambda = NULL,
  family = c("gaussian", "binomial"),
  degrees = rep(10, p),
  dfs = rep(5, p),
  bases = pseudo.bases(x, degrees, dfs, parallel = parallel, ...),
  type.measure = c("mse", "mae", "deviance", "class"),
  nfolds = 10,
  foldid,
  keep = FALSE,
  parallel = FALSE,
  ...
)
}
\arguments{
\item{x}{\code{x} matrix as in \code{gamsel}}

\item{y}{response \code{y} as in \code{gamsel}}

\item{lambda}{Optional use-supplied lambda sequence.  If \code{NULL},
default behaviour is for \code{gamsel} routine to automatically select a
good lambda sequence.}

\item{family}{\code{family} as in \code{gamsel}}

\item{degrees}{\code{degrees} as in \code{gamsel}}

\item{dfs}{\code{dfs} as in \code{gamsel}}

\item{bases}{\code{bases} as in \code{gamsel}}

\item{type.measure}{Loss function for cross-validated error calculation.
Currently there are four options: \code{mse} (mean squared error),
\code{mae} (mean absolute error), \code{deviance} (deviance, same as
\code{mse} for \code{family="gaussian"}), \code{class} (misclassification
error, for use with \code{family="binomial"}).}

\item{nfolds}{Numer of folds (default is 10).  Maximum value is \code{nobs}.
Small values of \code{nfolds} are recommended for large data sets.}

\item{foldid}{Optional vector of length \code{nobs} with values between 1
and \code{nfolds} specifying what fold each observation is in.}

\item{keep}{If \code{keep=TRUE}, a \emph{prevalidated} array is returned
containing fitted values for each observation and each value of
\code{lambda}. This means these fits are computed with this observation and
the rest of its fold omitted. The \code{folid} vector is also returned.
Default is keep=FALSE}

\item{parallel}{If \code{TRUE}, use parallel \code{foreach} to fit each
fold. See the example below for usage details.}

\item{\dots}{Other arguments that can be passed to \code{gamsel}.}
}
\value{
an object of class \code{"cv.gamsel"} is returned, which is a list
with the ingredients of the cross-validation fit.  \item{lambda}{the values
of \code{lambda} used in the fits.} \item{cvm}{The mean cross-validated
error - a vector of length \code{length(lambda)}.} \item{cvsd}{estimate of
standard error of \code{cvm}.} \item{cvup}{upper curve = \code{cvm+cvsd}.}
\item{cvlo}{lower curve = \code{cvm-cvsd}.} \item{nzero}{number of non-zero
coefficients at each \code{lambda}.} \item{name}{a text string indicating
type of measure (for plotting purposes).} \item{gamsel.fit}{a fitted gamsel
object for the full data.} \item{lambda.min}{value of \code{lambda} that
gives minimum \code{cvm}.} \item{lambda.1se}{largest value of \code{lambda}
such that error is within 1 standard error of the minimum.}
\item{fit.preval}{if \code{keep=TRUE}, this is the array of prevalidated
fits. Some entries can be \code{NA}, if that and subsequent values of
\code{lambda} are not reached for that fold} \item{foldid}{if
\code{keep=TRUE}, the fold assignments used} \item{index.min}{the sequence
number of the minimum lambda.} \item{index.1se}{the sequence number of the
1se lambda value.}
}
\description{
A routine for performing K-fold cross-validation for gamsel.
}
\details{
This function has the effect of running \code{gamsel} \code{nfolds}+1 times.
The initial run uses all the data and gets the \code{lambda} sequence.  The
remaining runs fit the data with each of the folds omitted in turn.  The
error is accumulated, and the average error and standard deviation over the
folds is computed.  Note that \code{cv.gamsel} does NOT search for values
for \code{gamma}. A specific value should be supplied, else \code{gamma=.4}
is assumed by default. If users would like to cross-validate \code{gamma} as
well, they should call \code{cv.gamsel} with a pre-computed vector
\code{foldid}, and then use this same fold vector in separate calls to
\code{cv.gamsel} with different values of \code{gamma}. Note also that the
results of \code{cv.gamsel} are random, since the folds are selected at
random. Users can reduce this randomness by running \code{cv.gamsel} many
times, and averaging the error curves.
}
\examples{

##data=gamsel:::gendata(n=500,p=12,k.lin=3,k.nonlin=3,deg=8,sigma=0.5)
data = readRDS(system.file("extdata/gamsel_example.RDS", package = "gamsel"))
attach(data)
bases=pseudo.bases(X,degree=10,df=6)
# Gaussian gam
gamsel.out=gamsel(X,y,bases=bases)
par(mfrow=c(1,2),mar=c(5,4,3,1))
summary(gamsel.out)
gamsel.cv=cv.gamsel(X,y,bases=bases)
par(mfrow=c(1,1))
plot(gamsel.cv)
par(mfrow=c(3,4))
plot(gamsel.out,newx=X,index=20)

}
\references{
Chouldechova, A. and Hastie, T. (2015) \emph{Generalized
Additive Model Selection}
}
\seealso{
\code{gamsel}, \code{plot} function for \code{cv.gamsel} object.
}
\author{
Alexandra Chouldechova and Trevor Hastie\cr Maintainer: Trevor
Hastie \email{hastie@stanford.edu}
}
\keyword{nonparametric}
\keyword{regression}
\keyword{smooth}
