% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdPlot2dProjection.R
\name{gdPlotParameters}
\alias{gdPlotParameters}
\title{Specify plot parameters for generative data}
\usage{
gdPlotParameters(
  numberOfRandomPoints = 0,
  densityValueThresholds = c(),
  densityValueColors = c("red")
)
}
\arguments{
\item{numberOfRandomPoints}{Number of randomly selected rows in generative data}

\item{densityValueThresholds}{Vector of density value thresholds}

\item{densityValueColors}{Vector of colors assigned to density value thresholds. The size must be the size
of densityValueThresholds plus one.}
}
\description{
Specify plot parameters for generative data passed to function gdPlot2dProjection().
When density value thresholds with assigned colors are specified generative data is drawn for density value ranges in increasing order.
}
\examples{
\dontrun{gdPlotParameters(250000, c(0.75), c("red", "green"))}
}
