% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Var-generics.R, R/Var-methods.R
\docType{methods}
\name{Var}
\alias{Var}
\alias{Var<-}
\alias{GaVar}
\alias{GaVar<-}
\alias{McfVar}
\alias{McfVar<-}
\alias{RtVar}
\alias{RtVar<-}
\alias{Var,character-method}
\alias{Var<-,.var,character-method}
\alias{Var,.expr-method}
\alias{Var<-,.expr,character-method}
\alias{Var,.gaVarList-method}
\alias{GaVar,character-method}
\alias{GaVar<-,.gaVar,character-method}
\alias{GaVar,.expr-method}
\alias{GaVar<-,.expr,character-method}
\alias{GaVar,.gaVarList-method}
\alias{McfVar,ANY-method}
\alias{RtVar,ANY-method}
\title{Google Analytics dimension and metric variables.}
\usage{
Var(object, ...)

Var(object) <- value

GaVar(object, ...)

GaVar(object) <- value

McfVar(object, ...)

McfVar(object) <- value

RtVar(object, ...)

RtVar(object) <- value

\S4method{Var}{character}(object)

\S4method{Var}{.var,character}(object) <- value

\S4method{Var}{.expr}(object)

\S4method{Var}{.expr,character}(object) <- value

\S4method{Var}{.gaVarList}(object)

\S4method{GaVar}{character}(object)

\S4method{GaVar}{.gaVar,character}(object) <- value

\S4method{GaVar}{.expr}(object)

\S4method{GaVar}{.expr,character}(object) <- value

\S4method{GaVar}{.gaVarList}(object)

\S4method{McfVar}{ANY}(object)

\S4method{RtVar}{ANY}(object)
}
\arguments{
\item{object}{an object that inherits from or extends the class '.var',
including 'gaDimVar', 'gaMetVar', 'mcfDimVar', 'mcfMetVar', 'rtDimVar',
'rtMetVar', 'gaExpr', 'mcfExpr', 'rtExpr', 'gaDimensions', 'gaMetrics',
'mcfDimensions', 'mcfMetrics', 'rtDimensions' and 'rtMetrics'.}

\item{...}{A replacement value for \code{object} coerced to class '.var'.}

\item{value}{any object that can be coerced to a valid \code{object} class.}
}
\value{
An object inheriting from the superclass '.var'
}
\description{
\code{Var} returns a '.var' object which is valid Google Analytics dimension
or metric for use with the core reporting, multi-channel-funnel reporting or
real-time reporting API.

\code{Var<-} sets the value of an object belonging to the superclass '.var'
or sets the var slot of an expression object belonging to superclass '.expr'

\code{GaVar} Gets or creates an object from the superclass .gaVar

\code{GaVar<-} replaces a '.var' object or sets the var slot of '.expr'
object to a Google Analytics Core Reporting API dimension or metric
that inherits from the class '.gaVar'.

\code{McfVar} Gets or creates an object from the superclass .mcfVar

\code{McfVar<-} replaces a '.var' object or sets the var slot of '.expr'
object to a Multi Channel Funnel Reporting API dimension or metric
that inherits from the class '.mcfVar'.

\code{RtVar} Gets or creates an object from the superclass .rtVar

\code{RtVar<-} replaces a '.var' object or sets the var slot of '.expr'
object to a Google Analytics Real Time Reporting API dimension or metric
that inherits from the class '.rtVar'.
}
\details{
Use \code{Var} to lookup a dimension or metric from the Google Analytics core
reporting, multi-channel-funnel reporting, or real-time reporting APIs, for
use in defining expressions (of superclass '.expr') or (to be implemented)
variable lists (of superclass '.varList') such as query dimensions, metrics
or sortBy parameters.

\code{Var} accepts either a character, '.var', or '.expr' object. A character
object will be coerced to a '.var' object by looking for a matching dimension
or metric from the Core Reporting, Multi-Channel Funnel Reporting, and
Real-Time Reporting APIs. Providing an '.expr' object will return the
dimension or metric used within that Google Analytics expression.
}
\section{Methods (by class)}{
\itemize{
\item \code{character}: Coerce a character to '.var'.

\item \code{object = .var,value = character}: Set a '.var' object to a new value coerced from character.

\item \code{.expr}: Get the variable of an expression object.

\item \code{object = .expr,value = character}: Set the variable of an expression object using a character value to be coerced to '.var'.

\item \code{.gaVarList}: Get the variables within a variable list object, such as sortBy, dimensions or metrics.

\item \code{character}: GaVar takes a GA variable name and determines whether to return a Dimension or Metric object

\item \code{object = .gaVar,value = character}: Set the Var of a gaExpr object.

\item \code{.expr}: Get the variable from expression object coerced to '.garVar'.

\item \code{object = .expr,value = character}: Set the variable of an expression to a .gaVar as named by a character value.

\item \code{.gaVarList}: Get the variables of a .gaVarList.

\item \code{ANY}: McfVar takes a MCF variable and determines whether to return a Dimension or Metric object

\item \code{ANY}: McfVar takes a RT variable and determines whether to return a Dimension or Metric object
}}

\examples{
Var("source")
dim <- Var("ga:medium")
Var(dim)
paid_traffic <- Expr(dim, "==", "cpc")
Var(paid_traffic)

expr1 <- Expr("pageviews", '>', 10)
Var(expr1) <- "uniquePageviews"

}
\seealso{
\itemize{ \item
  \href{https://developers.google.com/analytics/devguides/reporting/core/dimsmets}{Core
   Reporting API dimensions and metrics} \item
  \href{https://developers.google.com/analytics/devguides/reporting/realtime/dimsmets/}{Multi-Channel-Funnel
   Reporting API dimensions and metrics} \item
  \href{https://developers.google.com/analytics/devguides/reporting/mcf/dimsmets/}{Real-Time
   Reporting API dimensions and metrics} }
}
