% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Segment-generics.R, R/Segment-methods.R
\docType{methods}
\name{PerProduct}
\alias{PerProduct}
\alias{PerProduct,gaMetExpr-method}
\alias{PerProduct,formula-method}
\title{PerProduct}
\usage{
PerProduct(object, negation)

\S4method{PerProduct}{gaMetExpr}(object)

\S4method{PerProduct}{formula}(object)
}
\arguments{
\item{object}{A \code{gaMetExpr} object to coerce to hit-level}

\item{negation}{Boolean value indicating whether to negate the condition.}
}
\value{
A \code{gaMetExpr} object.
}
\description{
Set the scope of a gaMetExpr object to product-level.
}
\section{Methods (by class)}{
\itemize{
\item \code{gaMetExpr}: Set the scope of the supplied metric condition to
product-level.

\item \code{formula}: Set the scope of the supplied non-standard-evaluation
metric condition to product-level.
}}

\examples{
with_products_added_more_than_once <- PerProduct(Expr(~productAddsToCart > 1))

}
\seealso{
Other dynamic segment functions: \code{\link{DynSegment}},
  \code{\link{Exclude}}, \code{\link{Include}},
  \code{\link{IsNegated}}, \code{\link{PerHit}},
  \code{\link{PerSession}}, \code{\link{PerUser}},
  \code{\link{ScopeLevel}},
  \code{\link{SegmentConditionFilter}},
  \code{\link{Segments}}, \code{\link{Segment}}
}
\concept{dynamic segment functions}
