% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Segment-generics.R, R/Segment-methods.R
\docType{methods}
\name{PerSession}
\alias{PerSession}
\alias{PerSession,ANY-method}
\alias{PerSession,gaSegmentSequenceStep-method}
\alias{PerSession,gaSegmentSequenceFilter-method}
\alias{PerSession,gaMetExpr-method}
\alias{PerSession,formula-method}
\title{PerSession}
\usage{
PerSession(object, ..., negation)

\S4method{PerSession}{ANY}(object, ..., negation)

\S4method{PerSession}{gaSegmentSequenceStep}(object, ..., negation)

\S4method{PerSession}{gaSegmentSequenceFilter}(object, ..., negation)

\S4method{PerSession}{gaMetExpr}(object, ..., negation)

\S4method{PerSession}{formula}(object, ..., negation)
}
\arguments{
\item{object}{A \code{.gaSegmentFilter} or \code{gaMetExpr} object to coerce
to session-level. Alternatively, an dimension expression or segment filter
to coerce into a session scoped \code{gaDynSegment}.}

\item{...}{Other filters to include in the \code{gaDynSegment}.}

\item{negation}{Boolean value indicating whether to negate the condition.}
}
\value{
A \code{gaMetExpr}, \code{.gaSegmentFilter} or \code{gaDynSegment}.
}
\description{
Set the scope of a \code{.gaSegmentFilter} or \code{gaMetExpr} object to
session-level.
}
\section{Methods (by class)}{
\itemize{
\item \code{ANY}: Create a session level segment filter list from the
supplied expressions, interpreted as condition filters.

\item \code{gaSegmentSequenceStep}: Create a session-level segment sequence filter from the supplied
sequence expression.

\item \code{gaSegmentSequenceFilter}: Create a session-level segment sequence filter from the supplied
sequence expression.

\item \code{gaMetExpr}: Set the scope of the supplied metric condition to
session-level.

\item \code{formula}: Set the scope of the supplied non-standard-evaluation
metric condition to session-level.
}}

\note{
To define a \code{gaDynSegment} comprised of a single metric
expression, wrap the metric expression in an \code{Include} or
\code{Exclude} call.
}
\examples{
spent_more_than_100_in_a_session <- PerSession(Expr(~transactionRevenue > 100))

}
\seealso{
Other dynamic segment functions: \code{\link{DynSegment}},
  \code{\link{Exclude}}, \code{\link{Include}},
  \code{\link{IsNegated}}, \code{\link{PerHit}},
  \code{\link{PerProduct}}, \code{\link{PerUser}},
  \code{\link{ScopeLevel}},
  \code{\link{SegmentConditionFilter}},
  \code{\link{Segments}}, \code{\link{Segment}}
}
\concept{dynamic segment functions}
