\name{BFDP}
\alias{BFDP}
\title{Bayesian false-discovery probability}
\usage{BFDP(a,b,pi1,W,logscale=FALSE)}
\description{
This function calculates BFDP, the approximate \eqn{P(H_0|\hat\theta)}{Pr( H0 | thetahat )},
given an estiamte of the log relative risk, \eqn{\hat\theta}{thetahat}, the variance of
this estimate, \eqn{V}, the prior variance, \eqn{W}, and the prior probability of
a non-null association. When logscale=TRUE, the function accepts an estimate of the relative
risk, \eqn{\hat{RR}}{RRhat}, and the upper point of a 95\% confidence interval \eqn{RR_{hi}}{RRhi}.
}
\arguments{
  \item{a}{parameter value at which the power is to be evaluated}
  \item{b}{the variance for a, or the uppoer point (\eqn{RR_{hi}}{RRhi}) of a 95\%CI if logscale=FALSE}
  \item{pi1}{the prior probabiility of a non-null association}
  \item{W}{the prior variance}
  \item{logscale}{FALSE=the orginal scale, TRUE=the log scale}
}

\value{
The returned value is a list with the following components:

\item{PH0}{probability given a,b)}
\item{PH1}{probability given a,b,W)}
\item{BF}{Bayes factor, \eqn{P_{H_0}/P_{H_1}}{PH0/PH1}}
\item{BFDP}{Bayesian false-discovery probability}
\item{ABF}{approxmiate Bayes factor}
\item{ABFDP}{approximate Bayesian false-discovery probability}
}

\section{References}{
Wakefield J (2007) Bayesian measure of the probability of false discovery in genetic epidemiology studies.
Am J Hum Genet 81:208-227
}
\seealso{
\code{\link[gap]{FPRP}}
}
\examples{
\dontrun{
}
# Example from BDFP.xls by Jon Wakefield and Stephanie Monnier
# Step 1 - Pre-set an BFDP-level threshold for noteworthiness: BFDP values below this threshold are noteworthy									
# The threshold is given by R/(1+R) where R is the ratio of the cost of a false non-discovery to the cost of a false discovery									

T <- 0.8

# Step 2 - Enter up values for the prior that there is an association									

pi0 <- c(0.7,0.5,0.01,0.001,0.00001,0.6)

# Step 3 - Enter the value of the OR that is the 97.5% point of the prior, for example if we pick the value 1.5 we 
# believe that the prior probability that the odds ratio is bigger than 1.5 is 0.025.															

ORhi <- 3

W <- (log(ORhi)/1.96)^2
W

# Step 4 - Enter OR estimate and 95% confidence interval (CI) to obtain BFDP															

OR <- 1.316
OR_L <- 1.10
OR_U <- 2.50
logOR <- log(OR)
selogOR <- (log(OR_U)-log(OR))/1.96
r <- W/(W+selogOR^2)
r
z <- logOR/selogOR
z
ABF <- exp(-z^2*r/2)/sqrt(1-r)
ABF
FF <- (1-pi0)/pi0
FF
BFDPex <- FF*ABF/(FF*ABF+1)
BFDPex
pi0[BFDPex>T]

## now turn to BFDP

pi0 <- c(0.7,0.5,0.01,0.001,0.00001,0.6)
ORhi <- 3
OR <- 1.316
OR_U <- 2.50
W <- (log(ORhi)/1.96)^2
z <- BFDP(OR,OR_U,pi0,W)
z
}
\author{Jon Wakefield, Jing Hua Zhao}
\note{adapted from BFDP functions by Jon Wakefield on 17th April, 2007}
\keyword{models}
