\name{makeped}
\alias{makeped}
\title{A function to prepare pedigrees in post-MAKEPED format}
\usage{makeped(pifile="pedfile.pre", pofile="pedfile.ped", auto.select=1,
       with.loop=0, loop.file=NA, auto.proband=1, proband.file=NA)}

\description{
Many computer programs for genetic data analysis requires pedigree data to be in the so-called 
``post-MAKEPED'' format. This function performs this translation and allows for some 
inconsistences to be detected.

The first four columns of the input file contains the following information:

pedigree ID, individual ID, father's ID, mother's ID, sex

Either father's or mother's id is set to 0 for founders, i.e. individuals with no parents. 
Numeric coding for sex is 0=unknown, 1=male, 2=female. These can be followed by satellite 
information such as disease phenotype and marker information.

The output file has extra information extracted from data above.
}

\arguments{
\item{pifile}{input filename}
\item{pofile}{output filename}
\item{auto.select}{no loops in pedigrees and probands are selected automatically? 0=no, 1=yes}
\item{with.loop}{input data with loops? 0=no, 1=yes}
\item{loop.file}{filename containing pedigree id and an individual id for each loop, set if with.loop=1}
\item{auto.proband}{probands are selected automatically? 0=no, 1=yes}
\item{proband.file}{filename containing pedigree id and proband id, set if auto.proband=0 (not implemented)}
}

\details{
Before invoking makeped, input file, loop file and proband file have to be prepared.

By default, auto.select=1, so translation proceeds without considering loops and proband statuses.
If there are loops in the pedigrees, then set auto.select=0, with.loop=1, loop.file="filespec".

There may be several versions of makeped available, but their differences with this port should 
be minor.
}

\source{
\url{http://linkage.rockefeller.edu}
}

\value{
All output will be written in pofile

}

\examples{
\dontrun{
cwd <- getwd()
cs.dir <- file.path(path.package("gap.datasets"),"tests","kinship")
setwd(cs.dir)
dir()
makeped("ped7.pre","ped7.ped",0,1,"ped7.lop")
setwd(cwd)
}
}
\note{adapted from makeped.c by W Li and others}
\keyword{datagen}
