% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AuthState-class.R
\name{init_AuthState}
\alias{init_AuthState}
\title{Create an AuthState}
\usage{
init_AuthState(package = NA_character_, app, api_key, auth_active)
}
\arguments{
\item{package}{Package name, an optional string. The associated package will
generally by implied by the namespace within which the \code{AuthState} is
defined. But it's possible to record the package name explicitly and
seems like a good practice.}

\item{app}{An OAuth consumer application, as produced by \code{\link[httr:oauth_app]{httr::oauth_app()}}.}

\item{api_key}{API key (a string). Necessary in order to make unauthorized
"token-free" requests for public resources. Can be \code{NULL} if all requests
will be authorized, i.e. they will include a token.}

\item{auth_active}{Logical. \code{TRUE} means requests should include a token (and
probably not an API key). \code{FALSE} means requests should include an API key
(and probably not a token).}
}
\value{
An object of class \link{AuthState}.
}
\description{
Constructor function for objects of class \link{AuthState}.
}
\examples{
init_AuthState(
  package = "mypkg",
  app = gargle_app(),
  api_key = gargle_api_key(),
  auth_active = TRUE
)
}
