% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AuthState-class.R
\name{AuthState-class}
\alias{AuthState-class}
\alias{AuthState}
\title{Authorization state}
\description{
An \code{AuthState} object manages an authorization state, typically on behalf of
a client package that makes requests to a Google API.

The \href{https://gargle.r-lib.org/articles/gargle-auth-in-client-package.html}{How to use gargle for auth in a client package}
vignette describes a design for wrapper packages that relies on an \code{AuthState}
object. This state can then be incorporated into the package's requests for
tokens and can control the inclusion of tokens in requests to the target API.
\itemize{
\item \code{api_key} is the simplest way to associate a request with a specific
Google Cloud Platform \href{https://cloud.google.com/resource-manager/docs/cloud-platform-resource-hierarchy#projects}{project}.
A few calls to certain APIs, e.g. reading a public Sheet, can succeed
with an API key, but this is the exception.
\item \code{app} is an OAuth app associated with a specific Google Cloud Platform
\href{https://cloud.google.com/resource-manager/docs/cloud-platform-resource-hierarchy#projects}{project}.
This is used in the OAuth flow, in which an authenticated user authorizes
the app to access or manipulate data on their behalf.
\item \code{auth_active} reflects whether outgoing requests will be authorized by an
authenticated user or are unauthorized requests for public resources.
These two states correspond to sending a request with a token versus an
API key, respectively.
\item \code{cred} is where the current token is cached within a session, once one
has been fetched. It is generally assumed to be an instance of
\code{\link[httr:Token-class]{httr::TokenServiceAccount}} or
\code{\link[httr:Token-class]{httr::Token2.0}} (or a subclass thereof), probably
obtained via \code{\link[=token_fetch]{token_fetch()}} (or one of its constituent credential
fetching functions).
}

An \code{AuthState} should be created through the constructor function
\code{\link[=init_AuthState]{init_AuthState()}}, which has more details on the arguments.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{package}}{Package name.}

\item{\code{app}}{An OAuth consumer application.}

\item{\code{api_key}}{An API key.}

\item{\code{auth_active}}{Logical, indicating whether auth is active.}

\item{\code{cred}}{Credentials.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{AuthState$new()}}
\item \href{#method-print}{\code{AuthState$print()}}
\item \href{#method-set_app}{\code{AuthState$set_app()}}
\item \href{#method-set_api_key}{\code{AuthState$set_api_key()}}
\item \href{#method-set_auth_active}{\code{AuthState$set_auth_active()}}
\item \href{#method-set_cred}{\code{AuthState$set_cred()}}
\item \href{#method-clear_cred}{\code{AuthState$clear_cred()}}
\item \href{#method-get_cred}{\code{AuthState$get_cred()}}
\item \href{#method-has_cred}{\code{AuthState$has_cred()}}
\item \href{#method-clone}{\code{AuthState$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create a new AuthState
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AuthState$new(
  package = NA_character_,
  app = NULL,
  api_key = NULL,
  auth_active = TRUE,
  cred = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{package}}{Package name.}

\item{\code{app}}{An OAuth consumer application.}

\item{\code{api_key}}{An API key.}

\item{\code{auth_active}}{Logical, indicating whether auth is active.}

\item{\code{cred}}{Credentials.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
For more details on the parameters, see \code{\link[=init_AuthState]{init_AuthState()}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
Print an AuthState
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AuthState$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Not used.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_app"></a>}}
\if{latex}{\out{\hypertarget{method-set_app}{}}}
\subsection{Method \code{set_app()}}{
Set the OAuth app
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AuthState$set_app(app)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{app}}{An OAuth consumer application.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_api_key"></a>}}
\if{latex}{\out{\hypertarget{method-set_api_key}{}}}
\subsection{Method \code{set_api_key()}}{
Set the API key
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AuthState$set_api_key(value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{An API key.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_auth_active"></a>}}
\if{latex}{\out{\hypertarget{method-set_auth_active}{}}}
\subsection{Method \code{set_auth_active()}}{
Set whether auth is (in)active
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AuthState$set_auth_active(value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{Logical, indicating whether to send requests authorized with
user credentials.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_cred"></a>}}
\if{latex}{\out{\hypertarget{method-set_cred}{}}}
\subsection{Method \code{set_cred()}}{
Set credentials
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AuthState$set_cred(cred)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{cred}}{User credentials.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clear_cred"></a>}}
\if{latex}{\out{\hypertarget{method-clear_cred}{}}}
\subsection{Method \code{clear_cred()}}{
Clear credentials
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AuthState$clear_cred()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_cred"></a>}}
\if{latex}{\out{\hypertarget{method-get_cred}{}}}
\subsection{Method \code{get_cred()}}{
Get credentials
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AuthState$get_cred()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-has_cred"></a>}}
\if{latex}{\out{\hypertarget{method-has_cred}{}}}
\subsection{Method \code{has_cred()}}{
Report if we have credentials
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AuthState$has_cred()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AuthState$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
