% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggbr_semipara.R
\name{ggbr_semipara}
\alias{ggbr_semipara}
\title{Extract semiparametric estimates of the Gegenbauer factors.}
\usage{
ggbr_semipara(x, periods = NULL, k = 1, alpha = 0.8, method = "gsp")
}
\arguments{
\item{x}{(num) This should be a numeric vector representing the process to estimate.}

\item{periods}{(num) This parameter can be used to specify a fixed period or set of periods for the
Gegenbauer periodicity. For instance if you have monthly data, then it might be sensible (after an examination of the
periodogram) to set `periods = 12`. The default value is NULL. Either `periods` or `k` parameters must be specified
but not both - `periods` implies fixed period(s) are to be used and `k` implies that the periods should
be estimated.}

\item{k}{(int) This parameter indicates that the algorithm should estimate the `k` frequencies semi-parametrically,
before estimating the degree of fractional differencing at each period.

An alternative is the `periods` parameter which can be used to specify exactly which periods should be used by
the model.}

\item{alpha}{(num) Default = 0.8 - This is the bandwidth for the semiparametric estimate, and should be between 0 and 1.
Robinson (1994) indicated optimality for a (scaled) version of `alpha` = 0.8, at least for the "lpr" `method`.}

\item{method}{(char) One of "gsp" or "lpr" - lpr is the log-periodogram-regression technique, "gsp" is the Gaussian
semi-parametric technique. "gsp" is the default. Refer Arteche & Robinson (1998).}
}
\value{
An object of class "garma_semipara".
}
\description{
For a Gegenbauer process, use semi-parametric methods to estimate the Gegenbauer frequency and fractional differencing.
}
\examples{
data(AirPassengers)
ap <- as.numeric(diff(AirPassengers, 12))
sp <- ggbr_semipara(ap)
print(sp)
}
\references{
J Arteche and P Robinson. Semiparametric inference in seasonal and cyclical long memory processes. Journal of Time Series
Analysis, 21(1):1–25, 2000. DOI: https://doi.org/10.1111/1467-9892.00170

P Robinson. Rates of convergence and optimal spectral bandwidth for long range dependence. Probability Theory and Related
Fields, 99:443–473, 1994. DOI: https://doi.org/10.1007/BF01199901.
}
