% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readwrite_gasanalyzer.R
\name{export_ess_dive}
\alias{export_ess_dive}
\title{Export a subset of the data into the ESS-DIVE reporting format for leaf-level
gas exchange data.}
\usage{
export_ess_dive(df, filename = "", extra_cols = NULL)
}
\arguments{
\item{df}{a tibble with gas-exchange data.}

\item{filename}{path to the output file. If none provided the method returns
the data as a tibble.}

\item{extra_cols}{a character vector specifying additional columns (not
specified in the standard specified by Ely et al. 2021) to include in the
returned data or saved files.}
}
\value{
Nothing if a filename is provided. Otherwise, a tibble with
variables and headings specified by the ESS-DIVE gas-exchange standard
is returned.
}
\description{
Ely et al. (2021) proposed a standardized nomenclature for reporting
gas-exchange data and metadata within the framework of the Environmental
System Science Data Infrastructure for a Virtual Ecosystem (ESS-DIVE)
repository. This method converts data frames or tibbles created with
\code{gasanalyzer} to this standardized format. Note that the scope of the
proposed standard is limited, and therefore only a subset of the data
is exported. Users should add relevant additional columns and provide
relevant metadata.
}
\details{
If a filename is given as argument, the data is written into a comma
separated, UTF-8 encoded file without BOM and with CRLF line headings. In
addition, a data dictionary file ("_dd" is inserted at the end of the
filename, before the file extension). If no filename is provided, the
converted data is returned.
}
\examples{
example <- system.file("extdata//d13C.tsv", package = "gasanalyzer")

# read data and recalculate using default gas-exchange equations:
df <- read_gasexchange(example) |>
  recalculate(create_equations("default"))

# view df in ess_dive format:
export_ess_dive(df)

\dontshow{.old_wd <- setwd(tempdir())}
# save the data and a data dictionary:
export_ess_dive(df, "ess_dive_test.csv")
# read and show the dictionary:
readLines("ess_dive_test_dd.csv")
\dontshow{setwd(.old_wd)}
}
\references{
Ely KS, Rogers A, Agarwal DA, et al (2021) \emph{A reporting format
for leaf-level gas exchange data and metadata.} Ecol Inform 61:101232.
https://doi.org/10.1016/j.ecoinf.2021.101232
}
