% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Evaluator.R
\name{evaluatorFit}
\alias{evaluatorFit}
\title{Fit Evaluator}
\usage{
evaluatorFit(
  numSegments = 7L,
  statistic = c("BIC", "AIC", "adjusted.r.squared", "r.squared"),
  numThreads = NULL,
  maxNComp = NULL,
  sdfact = 1
)
}
\arguments{
\item{numSegments}{The number of CV segments used to estimate the optimal number of PLS components (between 2 and 2^16).}

\item{statistic}{The statistic used to evaluate the fitness (BIC, AIC, adjusted R^2, or R^2).}

\item{numThreads}{The maximum number of threads the algorithm is allowed to spawn (a value less than
1 or NULL means no threads).}

\item{maxNComp}{The maximum number of components the PLS models should consider (if not specified,
the number of components is not constrained)}

\item{sdfact}{The factor to scale the stand. dev. of the MSEP values when selecting the optimal number
of components. For the "one standard error rule", \code{sdfact} is 1.}
}
\value{
Returns an S4 object of type \code{\link{GenAlgFitEvaluator}} to be used as argument to
     a call of \code{\link{genAlg}}.
}
\description{
Creates the object that controls the evaluation step in the genetic algorithm
}
\details{
The fitness of a variable subset is assessed by how well a PLS model fits the data. To estimate
the optimal number of components for the PLS model, cross-validation is used.
}
\examples{
ctrl <- genAlgControl(populationSize = 200, numGenerations = 30, minVariables = 5,
    maxVariables = 12, verbosity = 1)
evaluator <- evaluatorFit(statistic = "BIC", numThreads = 1)

# Generate demo-data
set.seed(12345)
X <- matrix(rnorm(10000, sd = 1:5), ncol = 50, byrow = TRUE)
y <- drop(-1.2 + rowSums(X[, seq(1, 43, length = 8)]) + rnorm(nrow(X), 1.5));

result <- genAlg(y, X, control = ctrl, evaluator = evaluator, seed = 123)

subsets(result, 1:5)
}
\seealso{
Other GenAlg Evaluators: 
\code{\link{evaluatorLM}()},
\code{\link{evaluatorPLS}()},
\code{\link{evaluatorUserFunction}()}
}
\concept{GenAlg Evaluators}
