% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forward_sgwt.R
\name{forward_sgwt}
\alias{forward_sgwt}
\title{Compute Forward Spectral Graph Wavelet Transform.}
\usage{
forward_sgwt(f, evalues, evectors, b = 2)
}
\arguments{
\item{f}{Graph signal to analyze.}

\item{evalues}{Eigenvalues of the Laplacian matrix.}

\item{evectors}{Eigenvectors of the Laplacian matrix.}

\item{b}{Parameter that control the number of scales.}
}
\value{
\code{wc} wavelet coefficients.
}
\description{
Compute forward SGWT for signal f (without frame calculation). The calculation corresponds to the frame defined by the `tight_frame` function (without explicit calculation of the latter).
}
\references{
Göbel, F., Blanchard, G., von Luxburg, U. (2018). Construction of tight frames on graphs and application to denoising. In Handbook of Big Data Analytics (pp. 503-522). Springer, Cham.

de Loynes, B., Navarro, F., Olivier, B. (2021). Data-driven thresholding in denoising with Spectral Graph Wavelet Transform. Journal of Computational and Applied Mathematics, Vol. 389.

Hammond, D. K., Vandergheynst, P., & Gribonval, R. (2011). Wavelets on graphs via spectral graph theory. Applied and Computational Harmonic Analysis, 30(2), 129-150.
}
\seealso{
\code{\link{inverse_sgwt}}, \code{\link{tight_frame}}
}
