% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inverse_sgwt.R
\name{inverse_sgwt}
\alias{inverse_sgwt}
\title{Compute Inverse Spectral Graph Wavelet Transform.}
\usage{
inverse_sgwt(wc, evalues, evectors, b = 2)
}
\arguments{
\item{wc}{Wavelet coefficients.}

\item{evalues}{Eigenvalues of the Laplacian matrix.}

\item{evectors}{Eigenvectors of the Laplacian matrix.}

\item{b}{Parameter that control the number of scales.}
}
\value{
\code{f} SGWT adjoint applied to wc.
}
\description{
Compute inverse (adjoint) SGWT for signal f (without frame calculation). The calculation is perform for the frame defined by the `tight_frame` function. The tightness of the underlying frame implies that the computation is obtained by simply applying the adjoint linear transformation to the wavelet coefficients.
}
\references{
Göbel, F., Blanchard, G., von Luxburg, U. (2018). Construction of tight frames on graphs and application to denoising. In Handbook of Big Data Analytics (pp. 503-522). Springer, Cham.

de Loynes, B., Navarro, F., Olivier, B. (2021). Data-driven thresholding in denoising with Spectral Graph Wavelet Transform. Journal of Computational and Applied Mathematics, Vol. 389.

Hammond, D. K., Vandergheynst, P., & Gribonval, R. (2011). Wavelets on graphs via spectral graph theory. Applied and Computational Harmonic Analysis, 30(2), 129-150.
}
\seealso{
\code{\link{forward_sgwt}}, \code{\link{tight_frame}}
}
