% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basis_clean.R
\name{basis_clean}
\alias{basis_clean}
\title{Basis Cleaning - Removes records with certain record basis}
\usage{
basis_clean(df, basis.list = NA, basis.of.record = "basisOfRecord")
}
\arguments{
\item{df}{Data frame of occurrence records returned from \code{gators_download()}.}

\item{basis.list}{A list of basis to keep. If a list is not supplied, the filter will be interactive and users must respond to the function.}

\item{basis.of.record}{Default = "basisOfRecord". The name of the basis of record column in the data frame.}
}
\value{
Returns a data frame with records of desired record basis.
}
\description{
The \code{basis_clean()} function removes records based on basisOfRecord column.
}
\details{
This function requires no additional packages.
}
\examples{
cleaned_data <- basis_clean(data, basis.list = c("Preserved Specimen","Physical specimen"))

}
