% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frobregp.R
\name{frobregp}
\alias{frobregp}
\title{Robust regression using Huber's psi-function providing P-values}
\usage{
frobregp(y,x,cn=1,sg=0,q=-1,ind=0,inr=T,xinr=F)
}
\arguments{
\item{y}{Dependent variable}

\item{x}{Covariates}

\item{cn}{Tuning parameter for Huber's psi-function}

\item{sg}{Scale}

\item{q}{The number of covariates available}

\item{ind}{The subset of covariates for which the results are required}

\item{inr}{Logical, TRUE  to include intercept}

\item{xinr}{Logical TRUE if x already includes intercept}
}
\value{
ppi In order the subset ind, the regression coefficients, the P-values, the standard P-values

res  Residuals

sig  Scale
}
\description{
Robust regression using Huber's psi-function which provides P-values
}
\examples{
data(boston)
a<-frobregp(boston[,14],boston[,1:13])
}
