% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kummerM.R
\name{kummerM}
\alias{kummerM}
\alias{lauricella}
\title{Confluent \eqn{D}-Hypergeometric Function}
\usage{
kummerM(a, b, z, eps = 1e-06)
}
\arguments{
\item{a}{numeric.}

\item{b}{numeric}

\item{z}{numeric vector.}

\item{eps}{numeric. Precision for the sum (default 1e-06).}
}
\value{
A numeric value: the value of the Kummer's function,
with two attributes \code{attr(, "epsilon")} (precision of the result) and \code{attr(, "k")} (number of iterations).
}
\description{
Computes the Kummer's function, or confluent hypergeometric function.
}
\details{
The Kummer's confluent hypergeometric function is given by:
\deqn{\displaystyle{_1 F_1\left(a, b; z\right) = \sum_{n = 0}^{+\infty}{ \frac{ (a)_n }{ (b)_n } \frac{z^n}{n!} }}}

where \eqn{(z)_p} is the Pochhammer symbol (see \code{\link{pochhammer}}).

The \code{eps} argument gives the required precision for its computation.
It is the \code{attr(, "epsilon")} attribute of the returned value.
}
\references{
El Ghaziri, A., Bouhlel, N., Sapoukhina, N., Rousseau, D.,
On the importance of non-Gaussianity in chlorophyll fluorescence imaging.
Remote Sensing 15(2), 528 (2023).
\doi{10.3390/rs15020528}
}
\author{
Pierre Santagostini, Angélina El Ghaziri, Nizar Bouhlel
}
