% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gbm.cons.R
\name{gbm.cons}
\alias{gbm.cons}
\title{Conservation Area Mapping}
\usage{
gbm.cons(
  mygrids,
  subsets,
  alerts = TRUE,
  map = TRUE,
  BnW = TRUE,
  resvars,
  gbmautos = TRUE,
  savedir = tempdir(),
  expvars,
  tcs = NULL,
  lrs = rep(list(c(0.01, 0.005)), length(resvars)),
  bfs = rep(0.5, length(resvars)),
  ZIs = rep("CHECK", length(resvars)),
  colss = rep(list(grey.colors(1, 1, 1)), length(resvars)),
  linesfiless = rep(FALSE, length(resvars)),
  savegbms = rep(TRUE, length(resvars)),
  varints = rep(TRUE, length(resvars)),
  maps = rep(TRUE, length(resvars)),
  RSBs = rep(TRUE, length(resvars)),
  BnWs = rep(TRUE, length(resvars)),
  zeroes = rep(TRUE, length(resvars)),
  shape = NULL,
  pngtype = c("cairo-png", "quartz", "Xlib"),
  gridslat = 2,
  gridslon = 1,
  grids = NULL
)
}
\arguments{
\item{mygrids}{Gridded lat+long+data object to predict to.}

\item{subsets}{Subset name(s): character; single or vector, corresponding to
matching-named dataset objects e.g. read in by read.csv().}

\item{alerts}{Play sounds to mark progress steps.}

\item{map}{Produce maps.}

\item{BnW}{Also produce B&W maps?}

\item{resvars}{Vector of resvars cols from dataset objects for gbm.autos,
length(subsets)*species, no default.}

\item{gbmautos}{Do gbm.auto runs for species? Default TRUE, set FALSE if
already run and output files in expected directories.}

\item{savedir}{Save outputs to a temporary directory (default) else change to
current directory e.g. "/home/me/folder". Do not use getwd() here.}

\item{expvars}{List object of expvar vectors for gbm.autos, length = no. of
subsets * no. of species. No default.}

\item{tcs}{Gbm.auto parameters, auto-calculated below if not provided by user.}

\item{lrs}{Gbm.auto parameter, uses defaults if not provided by user.}

\item{bfs}{Gbm.auto parameter, uses defaults if not provided by user.}

\item{ZIs}{Gbm.auto parameter, autocalculated below if not provided by user.
Choose one entry.}

\item{colss}{Gbm.auto parameter, uses defaults if not provided by user.}

\item{linesfiless}{Gbm.auto parameter, uses defaults if not provided by user.}

\item{savegbms}{Gbm.auto parameter, uses defaults if not provided by user.}

\item{varints}{Gbm.auto parameter, uses defaults if not provided by user.}

\item{maps}{Gbm.auto parameter, uses defaults if not provided by user.}

\item{RSBs}{Gbm.auto parameter, uses defaults if not provided by user.}

\item{BnWs}{Gbm.auto parameter, uses defaults if not provided by user.}

\item{zeroes}{For breaks.grid, include zero-only category in colour
breakpoints and subsequent legend. Defaults to TRUE.}

\item{shape}{Coastline file for gbm.map.}

\item{pngtype}{File-type for png files, alternatively try "quartz" on Mac.
Choose one.}

\item{gridslat}{Per Gbm.auto defaults to 2.}

\item{gridslon}{Per Gbm.auto defaults to 1.}

\item{grids}{Dummy param for package testing for CRAN, ignore.}
}
\value{
Maps via gbm.map & saved data as csv file.
}
\description{
Runs gbm.auto for multiple subsets of the same overall dataset and
scales the combined results, leading to maps which highlight areas of high
conservation importance for multiple species in the same study area e.g.
using juvenile and adult female subsets to locate candidate nursery grounds
and spawning areas respectively.
}
\examples{
\donttest{
# Not run: downloads and saves external data.
data(grids)
gbm.cons(mygrids = grids, subsets = c("Juveniles","Adult_Females"),
         resvars = c(44:47,11:14),
         expvars = list(c(4:11,15,17,21,25,29,37),
                        c(4:11,15,18,22,26,30,38),
                        c(4:11,15,19,23,27,31),
                        c(4:11,15,20,24,28,32,39),
                        4:10, 4:10, 4:10, 4:10),
         tcs = list(c(2,14), c(2,14), 13, c(2,14), c(2,6), c(2,6), 6,
         c(2,6)),
         lrs = list(c(0.01,0.005), c(0.01,0.005), 0.005, c(0.01,0.005),
               0.005, 0.005, 0.001, 0.005),
         ZIs = rep(TRUE, 8),
         savegbms = rep(FALSE, 8),
         varints = rep(FALSE, 8),
         RSBs = rep(FALSE, 8),
         BnWs = rep(FALSE, 8),
         zeroes = rep(FALSE,8))
         }

}
\author{
Simon Dedman, \email{simondedman@gmail.com}
}
