% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/author_cloud.R
\name{author_cloud}
\alias{author_cloud}
\alias{author_frequency}
\title{Make Wordcloud of authors from Papers}
\usage{
author_cloud(authors, addstopwords = gcite_stopwords(),
  author_pattern = NULL, split = ",", verbose = TRUE,
  colors = c("#66C2A4", "#41AE76", "#238B45", "#006D2C", "#00441B"), ...)

author_frequency(authors, author_pattern = NULL, split = ",",
  addstopwords = gcite_stopwords(), verbose = TRUE)
}
\arguments{
\item{authors}{Vector of authors of papers}

\item{addstopwords}{Additional words to remove from wordcloud}

\item{author_pattern}{regular expression for patterns to exclude from 
individual authors}

\item{split}{split author names (default \code{","}), passed to
\code{\link{strsplit}}}

\item{verbose}{Print diagnostic messages}

\item{colors}{color words from least to most frequent.  Passed to 
\code{\link{gcite_wordcloud_spec}}}

\item{...}{additional options passed to \code{\link{gcite_wordcloud_spec}}}
}
\value{
A \code{data.frame} of the words and the frequencies of the
authors
}
\description{
Takes a vector of authors and then creates a frequency table
of those words and plots a wordcloud
}
\examples{
\dontrun{
L = gcite_author_info("John Muschelli")
paper_df = L$paper_df
authors = paper_df$authors
author_cloud(authors)
}
}
