% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{find_local_extrema}
\alias{find_local_extrema}
\title{Find local extrema of numeric vector}
\usage{
find_local_extrema(
  y,
  x = NULL,
  window_width = NULL,
  window_width_n = NULL,
  window_height = NULL,
  return = "index",
  return_maxima = TRUE,
  return_minima = TRUE,
  return_endpoints = TRUE,
  subset = NULL,
  na.rm = TRUE,
  width_limit = NULL,
  width_limit_n = NULL,
  height_limit = NULL
)
}
\arguments{
\item{y}{Numeric vector of y values in which to identify local extrema}

\item{x}{Optional numeric vector of corresponding x values}

\item{window_width}{Width of the window (in units of \code{x}) used to
search for local extrema. A narrower width will be more
sensitive to narrow local maxima/minima, while a wider
width will be less sensitive to local maxima/minima.}

\item{window_width_n}{The maximum number of data points a single 
extrema-search step is allowed to take. For example,
when maxima-finding, the function will not pass
a valley consisting of more than \code{window_width_n}
data points.

A smaller \code{window_width_n} will be more sensitive 
to narrow local maxima/minima, while a larger 
\code{window_width_n} will be less sensitive to 
narrow local maxima/minima.}

\item{window_height}{The maximum change in \code{y} a single extrema-search
step is allowed to take.  For example, when 
maxima-finding, the function will not pass a
valley deeper than \code{window_height}.

A smaller \code{window_height} will be more sensitive 
to shallow local maxima/minima, while a larger 
\code{window_height} will be less sensitive to 
shallow maxima/minima.}

\item{return}{One of c("index", "x", "y"), determining whether the function
will return the index, x value, or y value associated with the
identified extremas}

\item{return_maxima, return_minima}{Boolean for which classes of local extrema
to return}

\item{return_endpoints}{Should the first and last values in \code{y}
be included if they are in the returned 
vector of extrema?}

\item{subset}{A vector of Boolean values indicating which x and y values
should be included (TRUE) or excluded (FALSE).

If \code{return = "index"}, index will be for the whole 
vector and not the subset of the vector}

\item{na.rm}{Boolean whether NA's should be removed before analyzing}

\item{width_limit}{Deprecated, use \code{window_width} instead}

\item{width_limit_n}{Deprecated, use \code{window_width_n} instead}

\item{height_limit}{Deprecated, use \code{window_height} instead}
}
\value{
If \code{return = "index"}, a vector of indices corresponding 
          to local extrema in the data
          
        If \code{return = "x"}, a vector of x values corresponding
          to local extrema in the data
         
        If \code{return = "y"}, a vector of y values corresponding
          to local extrema in the data
}
\description{
This function takes a vector of \code{y} values and returns a vector
of the indices of all local value extrema (by default, this includes both
local minima and local maxima). One of \code{window_width}, 
\code{window_width_n}, or \code{window_height} must be provided
}
\details{
If multiple of \code{window_width}, \code{window_width_n}, or 
\code{window_height} are provided, steps are limited conservatively 
(a single step must meet all criteria)

This function is designed to be compatible for use within
 dplyr::group_by and dplyr::summarize
 
In the case of exact ties in \code{y} values within \code{window_width}, 
\code{window_width_n}, and \code{window_height} (as applicable) of each 
other, only the first local extrema is returned.
}
