% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{trans_wide_to_tidy}
\alias{trans_wide_to_tidy}
\title{Pivot widemeasures longer}
\usage{
trans_wide_to_tidy(
  wides,
  data_cols = NA,
  id_cols = NA,
  names_to = "Well",
  values_to = "Measurements",
  values_to_numeric = TRUE,
  ...
)
}
\arguments{
\item{wides}{A single widemeasures data.frame, or a list of widemeasures
data.frame's}

\item{data_cols, id_cols}{Specifies which columns have data vs are ID's
(in \code{tidyr::pivot_longer} parlance). Each can be
a single vector (which will be applied for all
widemeasures) or a list of vectors, with each
vector corresponding to the same-index widemeasure
in \code{widemeasures}

Entries that are NA in the list will not be used

If neither data_cols nor id_cols are specified,
user must provide arguments to tidyr::pivot_longer
via \code{...} for at least the \code{cols} argument
and these arguments provided via \code{...} will
be used for all \code{widemeasures} data.frame's}

\item{names_to, values_to}{Specifies the output column names created by
tidyr::pivot_longer. Each can be provided as vectors
the same length as \code{widemeasures}
Note that if neither data_cols nor id_cols}

\item{values_to_numeric}{logical indicating whether values will be coerced
to numeric. See below for when this may be
overridden by arguments passed in \code{...}}

\item{...}{Other functions to be passed to \code{tidyr::pivot_longer}
Note that including values_transform here will override the
behavior of values_to_numeric}
}
\value{
Pivoted longer data.frame (if \code{widemeasures} is a single data.frame)
        or list of pivoted longer data.frame's (if \code{widemeasures} is
        a list of data.frame's)
}
\description{
Essentially a wrapper for tidyr::pivot_longer that works on both a single
widemeasures as well as a list of widemeasures
}
