% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{read_tidys}
\alias{read_tidys}
\title{Read tidy-shaped files}
\usage{
read_tidys(
  files,
  filetype = NULL,
  startrow = NULL,
  endrow = NULL,
  startcol = NULL,
  endcol = NULL,
  sheet = NULL,
  run_names = NULL,
  run_names_header = NULL,
  run_names_dot = FALSE,
  run_names_path = TRUE,
  run_names_ext = FALSE,
  na.strings = c("NA", ""),
  extension,
  names_to_col,
  ...
)
}
\arguments{
\item{files}{A vector of filepaths (relative to current working directory)
where each one is a tidy-shaped data file}

\item{filetype}{(optional) the type(s) of the files. Options include:

                 "csv", "xls", or "xlsx".
                 
                 "tbl" or "table" to use \code{read.table} to read the file,
                 "csv2" to use \code{read.csv2}, "delim" to 
                 use \code{read.delim}, or "delim2" to use \code{read.delim2}.
                 
                 If none provided, \code{read_tidys} will infer filetype(s) 
                 from the extension(s) in \code{files}. When extension is 
                 not "csv", "xls", or "xlsx", will use "table".}

\item{startrow, endrow, startcol, endcol}{(optional) the rows and columns where 
the data are located in \code{files}.

Can be a vector or list the same length as \code{files}, or
a single value that applies to all \code{files}. Values
can be numeric or a string that will be automatically
converted to numeric by \code{from_excel}.

If not provided, data is presumed to begin on the first
row and column of the file(s) and end on the last row and
column of the file(s).}

\item{sheet}{The sheet of the input files where data is located (if input
files are .xls or .xlsx). If not specified defaults to the first}

\item{run_names}{Names to give the tidy files read in. By default uses the
file names if not specified. These names may be added
to the resulting data frame depending on the value of
the \code{names_to_col} argument}

\item{run_names_header}{Should the run names (provided in \code{run_names}
or inferred from \code{files}) be added as a column to the
output? 

If \code{run_names_header} is TRUE, they will be added with
the column name "run_name"

If \code{run_names_header} is FALSE, they will not be added.

If \code{run_names_header} is a string, they will be added
and the column name will be the string specified
for \code{run_names_header}.

If \code{run_names_header} is NULL, they only will be 
added if there are multiple tidy data.frames being read.
In which case, the column name will be "run_name"}

\item{run_names_dot}{If run_names are inferred from filenames, should 
the leading './' (if any) be retained}

\item{run_names_path}{If run_names are inferred from filenames, should 
the path (if any) be retained}

\item{run_names_ext}{If run_names are inferred from filenames, should 
the file extension (if any) be retained}

\item{na.strings}{A character vector of strings which are to be interpreted
as \code{NA} values by \code{utils::read.csv},
\code{readxl::read_xls}, \code{readxl::read_xlsx},
or \code{utils::read.table}}

\item{extension}{Allowed for backward compatibility; \code{filetype} is
now the preferred argument name.}

\item{names_to_col}{Allowed for backward compatibility; 
\code{run_names_header} is now the preferred argument name.}

\item{...}{Other arguments passed to \code{utils::read.csv},
\code{readxl::read_xls}, \code{readxl::read_xlsx}, or
\code{utils::read.table}
sheet}
}
\value{
A dataframe containing a single tidy data.frame, or
        A list of tidy-shaped data.frames named by filename
}
\description{
A function that imports tidy-shaped files into R. Largely acts as a
wrapper for \code{utils::read.csv}, \code{readxl::read_xls},
\code{readxl::read_xls}, or \code{readxl::read_xlsx}, but can handle
multiple files at once and has additional options for taking subsets 
of rows/columns rather than the entire file and for adding filename 
or run names as an added column in the output.
}
\details{
\code{startrow}, \code{endrow}, \code{startcol}, \code{endcol}, 
\code{sheet} and \code{filetype} can either be a single value that 
applies for all files or vectors or lists the same length as \code{files}

Note that the startrow is always assumed to be a header
}
