% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdalBindings.R
\name{formulaCalculate}
\alias{formulaCalculate}
\title{Calculate raster values based on a formula}
\usage{
formulaCalculate(formula, data, updateBand)
}
\arguments{
\item{formula}{Formula. A formula to apply to the RasterBands from \code{data}}

\item{data}{List. A named list with the used variables in the textual formula}

\item{updateBand}{GDALRasterBand. The GDALRasterBand which will be updated with the calculated values.}
}
\value{
Nothing, it just updates the band of interest.
}
\description{
Calculate raster values based on a formula
}
\examples{
# Parameters
raster_path <- file.path(tempdir(), "output.tif")
ul_lat <- -15
ul_lon <- -45
lr_lat <- -25
lr_lon <- -35
res <- c(0.01, -0.01)
datatype <- GDALDataType$GDT_Int32
nbands <- 2
projstring <- "EPSG:4326"
nodata <- -1
co <- c("TILED=YES", "BLOCKXSIZE=512", "BLOCKYSIZE=512", "COMPRESSION=LZW")

# Create a new raster dataset
ds <- createDataset(
  raster_path = raster_path,
  nbands = nbands,
  datatype = datatype,
  projstring = projstring,
  lr_lat = lr_lat,
  ul_lat = ul_lat,
  ul_lon = ul_lon,
  lr_lon = lr_lon,
  res = res,
  nodata = nodata,
  co = co
)

# Get the GDALRasterBand for ds
band <- ds[[1]]

# The updateBand can be the same
# using a different one just for testing
updateBand <- ds[[2]]

# Set some dummy values
band[[0, 0]] <- 1:(512 * 512)

# Calculate the double - 10
formulaCalculate(
  formula = ~x * 2 - 10,
  data = list(x = band),
  updateBand = updateBand
)

ds$Close()

}
