% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdal_contour.R
\name{gdal_contour}
\alias{gdal_contour}
\title{gdal_contour}
\usage{
gdal_contour(src_filename, dst_filename, b, a, threeD, inodata, snodata, i,
  f = "ESRI Shapefile", dsco, lco, off, fl, nln, output_Vector = FALSE,
  config, ignore.full_scan = TRUE, verbose = FALSE)
}
\arguments{
\item{src_filename}{Character. Any OGR supported readable datasource.}

\item{dst_filename}{Character. The OGR supported output file.}

\item{b}{Numeric. Picks a particular band to get the DEM from. Defaults to band 1.}

\item{a}{Character. Provides a name for the attribute in which to put the elevation. If not provided no elevation attribute is attached.}

\item{threeD}{Logical. (GDAL parameter '3d') Force production of 3D vectors instead of 2D. Includes elevation at every vertex.}

\item{inodata}{Logical. Ignore any nodata value implied in the dataset - treat all values as valid.}

\item{snodata}{Numeric. Input pixel value to treat as "nodata".}

\item{i}{Numeric. Elevation interval between contours.}

\item{f}{Character. Create output in a particular format, default is "ESRI Shapefiles".}

\item{dsco}{Character. Dataset creation option (format specific).  Follows "NAME=VALUE" format.}

\item{lco}{Character. Layer creation option (format specific).  Follows "NAME=VALUE" format.}

\item{off}{Numeric. Offset from zero relative to which to interpret intervals.}

\item{fl}{Character. Name one or more "fixed levels" to extract.}

\item{nln}{Character. Provide a name for the output vector layer. Defaults to "contour".}

\item{output_Vector}{Logical. Return output dst_filename as a Spatial* object.  Currently only works with f="ESRI Shapefile".}

\item{config}{Character. Sets runtime configuration options for GDAL.  See https://trac.osgeo.org/gdal/wiki/ConfigOptions for more information.}

\item{ignore.full_scan}{Logical. If FALSE, perform a brute-force scan if other installs are not found.  Default is TRUE.}

\item{verbose}{Logical. Enable verbose execution? Default is FALSE.}
}
\value{
output vector filename or SpatialLinesDataFrame object.
}
\description{
R wrapper for gdal_contour: builds vector contour lines from a raster elevation model
}
\details{
This is an R wrapper for the 'gdal_contour' function that is part of the 
Geospatial Data Abstraction Library (GDAL).  It follows the parameter naming
conventions of the original function, with some modifications to allow for more R-like
parameters.  For all parameters, the user can use a single character string following,
precisely, the gdal_contour format (\url{http://www.gdal.org/gdal_contour.html}), or,
in some cases, can use R vectors to achieve the same end.  

This function assumes the user has a working GDAL on their system.  If the 
"gdalUtils_gdalPath" option has been set (usually by gdal_setInstallation),
the GDAL found in that path will be used.  If nothing is found, gdal_setInstallation
will be executed to attempt to find a working GDAL that has the right drivers 
as specified with the "of" (output format) parameter.

The user can choose to (optionally) return a RasterBrick of the output file (assuming
raster/rgdal supports the particular output format).
}
\examples{
# We'll pre-check to make sure there is a valid GDAL install
# and that raster and rgdal are also installed.
# Note this isn't strictly neccessary, as executing the function will
# force a search for a valid GDAL install.
gdal_setInstallation()
valid_install <- !is.null(getOption("gdalUtils_gdalPath"))
if(require(raster) && require(rgdal) && valid_install)
{
# Example from the original gdal_contour documentation:
# 	gdal_contour -a elev dem.tif contour.shp -i 10.0 
# Choose a DEM:
input_dem  <- system.file("external/tahoe_lidar_bareearth.tif", package="gdalUtils")
# Setup an output filename (shapefile):
output_shapefile <- paste(tempfile(),".shp",sep="")
contour_output <- gdal_contour(src_filename=input_dem,dst_filename=output_shapefile,
		a="Elevation",i=5.,output_Vector=TRUE)
# Plot the contours using spplot:
spplot(contour_output["Elevation"],contour=TRUE)
}
}
\references{
\url{http://www.gdal.org/gdal_contour.html}
}
\author{
Jonathan A. Greenberg (\email{gdalUtils@estarcion.net}) (wrapper) and Frank Warmerdam (GDAL lead developer).
}
