% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{footprint}
\alias{footprint}
\title{Compute footprint of a raster}
\usage{
footprint(src_filename, dst_filename, cl_arg = NULL)
}
\arguments{
\item{src_filename}{Character string. Filename of the source raster.}

\item{dst_filename}{Character string. Filename of the destination vector.
If the file and the output layer exist, the new footprint is appended to
them, unless the \code{-overwrite} command-line argument is used.}

\item{cl_arg}{Optional character vector of command-line arguments for
\code{gdal_footprint}.}
}
\value{
Logical indicating success (invisible \code{TRUE}).
An error is raised if the operation fails.
}
\description{
\code{footprint()} is a wrapper of the \command{gdal_footprint} command-line
utility (see \url{https://gdal.org/programs/gdal_footprint.html}).
The function can be used to compute the footprint of a raster file, taking
into account nodata values (or more generally the mask band attached to
the raster bands), and generating polygons/multipolygons corresponding to
areas where pixels are valid, and write to an output vector file.
Refer to the GDAL documentation at the URL above for a list of command-line
arguments that can be passed in \code{cl_arg}. Requires GDAL >= 3.8.
}
\details{
Post-vectorization geometric operations are applied in the following order:
\itemize{
\item optional splitting (\code{-split_polys})
\item optional densification (\code{-densify})
\item optional reprojection (\code{-t_srs})
\item optional filtering by minimum ring area (\code{-min_ring_area})
\item optional application of convex hull (\code{-convex_hull})
\item optional simplification (\code{-simplify})
\item limitation of number of points (\code{-max_points})
}
}
\examples{
evt_file <- system.file("extdata/storml_evt.tif", package="gdalraster")
out_file <- paste0(tempdir(), "/", "storml.geojson")

# Requires GDAL >= 3.8
if (as.integer(gdal_version()[2]) >= 3080000) {
  # command-line arguments for gdal_footprint
  args <- c("-t_srs", "EPSG:4326")
  footprint(evt_file, out_file, args)

  deleteDataset(out_file)
}
}
\seealso{
\code{\link[=polygonize]{polygonize()}}
}
