% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{vsi_curl_clear_cache}
\alias{vsi_curl_clear_cache}
\title{Clean cache associated with /vsicurl/ and related file systems}
\usage{
vsi_curl_clear_cache(partial = FALSE, file_prefix = "")
}
\arguments{
\item{partial}{Logical scalar. Whether to clear the cache only for a given
filename (see Details).}

\item{file_prefix}{Character string. Filename prefix to use if
\code{partial = TRUE}.}
}
\value{
No return value, called for side effects.
}
\description{
\code{vsi_curl_clear_cache()} cleans the local cache associated with /vsicurl/
(and related file systems). This function is a wrapper for
\code{VSICurlClearCache()} and \code{VSICurlPartialClearCache()} in the GDAL Common
Portability Library. See Details for the GDAL documentation.
}
\details{
/vsicurl/ (and related file systems like /vsis3/, /vsigs/, /vsiaz/,
/vsioss/, /vsiswift/) cache a number of metadata and data for faster
execution in read-only scenarios. But when the content on the server-side
may change during the same process, those mechanisms can prevent opening
new files, or give an outdated version of them.
If \code{partial = TRUE}, cleans the local cache associated for a given filename
(and its subfiles and subdirectories if it is a directory).
}
\examples{
vsi_curl_clear_cache()
}
