% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom.R
\name{bbox_transform}
\alias{bbox_transform}
\title{Transform a bounding box to a different projection}
\usage{
bbox_transform(bbox, srs_from, srs_to)
}
\arguments{
\item{bbox}{Numeric vector of length four containing a bounding box
(xmin, ymin, xmax, ymax) to transform.}

\item{srs_from}{Character string in OGC WKT format specifying the
spatial reference system for \code{bbox}.}

\item{srs_to}{Character string in OGC WKT format specifying the target
spatial reference system.}
}
\value{
Numeric vector of length four containing a transformed bounding box
(xmin, ymin, xmax, ymax).
}
\description{
\code{bbox_transform()} is a convenience function for:

\if{html}{\out{<div class="sourceCode">}}\preformatted{bbox_to_wkt(bbox) |>
  g_transform(srs_from, srs_to) |>
  bbox_from_wkt()
}\if{html}{\out{</div>}}
}
\examples{
elev_file <- system.file("extdata/storml_elev.tif", package="gdalraster")
ds <- new(GDALRaster, elev_file)
ds$bbox()
bbox_transform(ds$bbox(), ds$getProjection(), epsg_to_wkt(4326))
ds$close()
}
\seealso{
\code{\link[=g_transform]{g_transform()}}, \code{\link[=bbox_from_wkt]{bbox_from_wkt()}}, \code{\link[=bbox_to_wkt]{bbox_to_wkt()}}
}
