% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{inv_project}
\alias{inv_project}
\title{Inverse project geospatial x/y coordinates to longitude/latitude}
\usage{
inv_project(pts, srs, well_known_gcs = "")
}
\arguments{
\item{pts}{A two-column data frame or numeric matrix containing geospatial
x/y coordinates.}

\item{srs}{Character string specifying the projected spatial reference
system for \code{pts}. May be in WKT format or any of the formats supported by
\code{\link[=srs_to_wkt]{srs_to_wkt()}}.}

\item{well_known_gcs}{Optional character string containing a supported
well known name of a geographic coordinate system (see Details for
supported values).}
}
\value{
Numeric array of longitude, latitude. An error is raised if the
transformation cannot be performed.
}
\description{
\code{inv_project()} transforms geospatial x/y coordinates to
longitude/latitude in the same geographic coordinate system used by the
given projected spatial reference system. The output long/lat can
optionally be set to a specific geographic coordinate system by specifying
a well known name (see Details).
}
\details{
By default, the geographic coordinate system of the projection specified
by \code{srs} will be used. If a specific geographic coordinate system is
desired, then \code{well_known_gcs} can be set to one of the values below:
\tabular{rl}{
EPSG:n \tab where n is the code of a geographic coordinate system\cr
WGS84  \tab same as EPSG:4326\cr
WGS72  \tab same as EPSG:4322\cr
NAD83  \tab same as EPSG:4269\cr
NAD27  \tab same as EPSG:4267\cr
CRS84  \tab same as WGS84\cr
CRS72  \tab same as WGS72\cr
CRS27  \tab same as NAD27
}
The returned array will always be in longitude, latitude order
(traditional GIS order) regardless of the axis order defined for the
names above.
}
\examples{
pt_file <- system.file("extdata/storml_pts.csv", package="gdalraster")
## id, x, y in NAD83 / UTM zone 12N
pts <- read.csv(pt_file)
print(pts)
inv_project(pts[,-1], "EPSG:26912")
}
\seealso{
\code{\link[=transform_xy]{transform_xy()}}
}
