% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{vsi_rmdir}
\alias{vsi_rmdir}
\title{Delete a directory}
\usage{
vsi_rmdir(path, recursive = FALSE)
}
\arguments{
\item{path}{Character string. The path to the directory to be deleted.}

\item{recursive}{Logical scalar. \code{TRUE} to delete the directory and its
content. Defaults to \code{FALSE}.}
}
\value{
\code{0} on success or \code{-1} on an error.
}
\description{
\code{vsi_rmdir()} deletes a directory object from the file system. On some
systems the directory must be empty before it can be deleted.
With \code{recursive = TRUE}, deletes a directory object and its content from
the file system.
This function goes through the GDAL \code{VSIFileHandler} virtualization and may
work on unusual filesystems such as in memory.
It is a wrapper for \code{VSIRmdir()} and \code{VSIRmdirRecursive()} in the GDAL
Common Portability Library.
}
\note{
/vsis3/ has an efficient implementation for deleting recursively. Starting
with GDAL 3.4, /vsigs/ has an efficient implementation for deleting
recursively, provided that OAuth2 authentication is used.
}
\examples{
new_dir <- file.path(tempdir(), "newdir")
vsi_mkdir(new_dir)
vsi_rmdir(new_dir)
}
\seealso{
\code{\link[=deleteDataset]{deleteDataset()}}, \code{\link[=vsi_mkdir]{vsi_mkdir()}}, \code{\link[=vsi_read_dir]{vsi_read_dir()}}, \code{\link[=vsi_unlink]{vsi_unlink()}}
}
