% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalize.R
\name{normalize}
\alias{normalize}
\alias{normalize,TransitionLayer-method}
\title{Normalize}
\usage{
normalize(x, ...)
}
\arguments{
\item{x}{object of class \code{Transition*}}

\item{...}{optional argument \code{method} (see Details)}
}
\value{
an object of class \code{TransitionLayer}
}
\description{
Normalize the transition matrix.
}
\details{
argument \code{method} passed through \code{...} 
 a character for the normalization method
 the default is 'row' users can set the optional method argument 
 to either "col" or "symm"

Normalization of the weighted adjacency matrix in the Transition* object. 
 Matrix values are divided by their respective row-sums, column-sums, 
 or the product of the square-roots of both (symmetric normalization). 
 
The default  \code{method} is row-normalization. To use the other normalization 
 methods, users can set the optional \code{method} argument 
 to either "col" or "symm". 
 
For random walk calculations a symmetric matrix is needed (method = "symm").
}
\examples{
library("raster")
r <- raster(ncol=36,nrow=18)
r <- setValues(r,rep(1,times=ncell(r)))
tr <- transition(r, mean, directions=8)

normalize(tr)

normalize(tr, method="symm")

}
\references{
von Luxburg, U. 2007. A tutorial on spectral clustering. 
 Statistics and Computing 17(4), 395-416. 
 \doi{https://doi.org/10.1007/s11222-007-9033-z}

Chung, F. 1997. Spectral Graph Theory. Conference Board of 
 the Mathematical Sciences, Washington.
}
\author{
Jacob van Etten
}
\keyword{methods}
\keyword{spatial}
