% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdm.createsitepair.R
\name{createsitepair}
\alias{createsitepair}
\title{Create Site-Pair Table}
\usage{
createsitepair(dist, spdata, envInfo, dXCol, dYCol, siteCol, weightsType,
custWeights)
}
\arguments{
\item{dist}{The lower half of a site-by-site distance (dissimilarity) matrix,
provided by the \code{\link[gdm]{formatsitepair}} function.}

\item{spdata}{Input species data, the same as the bioData input to the
\code{\link[gdm]{formatsitepair}} function.}

\item{envInfo}{Input environmental data. Only accepts data tables as input.
If the environmental data for \code{\link[gdm]{formatsitepair}} are rasters, the
data would have been extracted into table format within
\code{\link[gdm]{formatsitepair}}.}

\item{dXCol}{Input x coordinate, the same as the XColumn input to the
\code{\link[gdm]{formatsitepair}} function.}

\item{dYCol}{Input y coordinate, the same as the YColumn input to the
\code{\link[gdm]{formatsitepair}} function.}

\item{siteCol}{Site column, taken from either the species or environmental
tables.}

\item{weightsType}{The method of determining the site-pair weights used in
model fitting.}

\item{custWeights}{Custom weights, as a vector, if given by the user.}
}
\value{
A site-pair table with appropriate distance (dissimilarity) and
weight columns used for fitting GDM.
}
\description{
Creates a site-pair table from the lower half of a site-by-site distance
(dissimilarity) matrix. This function is called from the
\code{\link[gdm]{formatsitepair}} function and not needed by the user.
}
\note{
This function is called from the \code{\link[gdm]{formatsitepair}} function
and not needed by the user.
}
\seealso{
\code{\link[gdm]{formatsitepair}}
}
\keyword{gdm}
\keyword{internal}
