% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gozh.R
\name{gozh}
\alias{gozh}
\title{geographically optimal zones-based heterogeneity(GOZH) model}
\usage{
gozh(formula, data, cores = 1, type = "factor", alpha = 0.95, ...)
}
\arguments{
\item{formula}{A formula of GOZH model.}

\item{data}{A data.frame, tibble or sf object of observation data.}

\item{cores}{(optional) A positive integer(default is 1). If cores > 1, a 'parallel' package
cluster with that many cores is created and used. You can also supply a cluster object.}

\item{type}{(optional) The type of geographical detector,which must be \code{factor}(default),
\code{interaction}, \code{risk}, \code{ecological}.You can run one or more types at one time.}

\item{alpha}{(optional) Specifies the size of confidence level.Default is \code{0.95}.}

\item{...}{(optional) Other arguments passed to \code{rpart_disc()}.}
}
\value{
A list of GOZH model result.
\describe{
\item{\code{factor}}{the result of factor detector}
\item{\code{interaction}}{the result of interaction detector}
\item{\code{risk}}{the result of risk detector}
\item{\code{ecological}}{the result of ecological detector}
}
}
\description{
Function for geographically optimal zones-based heterogeneity(GOZH) model
}
\examples{
data('ndvi')
g = gozh(NDVIchange ~ ., data = ndvi)
g

}
\references{
Luo, P., Song, Y., Huang, X., Ma, H., Liu, J., Yao, Y., & Meng, L. (2022). Identifying determinants of
spatio-temporal disparities in soil moisture of the Northern Hemisphere using a geographically optimal
zones-based heterogeneity model. ISPRS Journal of Photogrammetry and Remote Sensing: Official
Publication of the International Society for Photogrammetry and Remote Sensing (ISPRS), 185, 111–128.
https://doi.org/10.1016/j.isprsjprs.2022.01.009
}
\author{
Wenbo Lv \email{lyu.geosocial@gmail.com}
}
