% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/access_fn.R
\name{normalize}
\alias{normalize}
\title{Normalize raster.}
\usage{
normalize(layer, method = "standard", filepath = NULL)
}
\arguments{
\item{layer}{SpatRaster. Object with a single layer as defined by package terra.}

\item{method}{character. Specifying \code{'standard'}, \code{'range'} or \code{'rank'}.}

\item{filepath}{character. Optional, specifies a path to the output file.}
}
\value{
A raster layer.
}
\description{
Normalize a raster file according to one three methods, 'standard', 'range' or 'rank'.
}
\details{
The three options, "standard" standardizes data to a mean = 0 and sd = 1,
"range" standardizes to a range of 0 to 1, and "rank" similarly standardizes to
a range of 0 to 1 but does so after ranking all points.
}
\examples{
\dontrun{
region = gecko.data("layers")[[1]]
ranked_region = normalize(region, method = "rank")
}
}
