% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_request.R
\name{api_request}
\alias{api_request}
\title{Make an API call}
\usage{
api_request(url, max_attempts = 3)
}
\arguments{
\item{url}{(character): URL to call.}

\item{max_attempts}{(double, positive): specifies the
maximum number of attempts to call the CoinGecko API (e.g., if
the first call fails for some reason). Additional attempts are
implemented with an exponential backoff. Defaults to 3.}
}
\value{
A named list, the structure of which will vary depending on the
actual \code{GET} request made.
}
\description{
Performs \code{GET} requests, with a built-in exponential backoff mechanism for retries
}
\details{
This function only performs \code{GET} requests. The \code{url} is
expected to be built properly before passing onto this function.
The returned data are expected to be in JSON format. This function
will automatically parse the response object and return a named R list
with the respective elements. If no data can be retrieved (e.g. because
of a misspecified query parameter), the function will return nothing
(\code{NULL}).
}
\keyword{internal}
