% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coin_tickers.R
\name{coin_tickers}
\alias{coin_tickers}
\title{Exchange tickers}
\usage{
coin_tickers(coin_id, exchange_id, max_attempts = 3)
}
\arguments{
\item{coin_id}{(character): ID of the coin of interest. An
up-to-date list of supported coins and their IDs can be retrieved
with the \code{\link[=supported_coins]{supported_coins()}} function.}

\item{exchange_id}{(character): ID of the exchange to retrieve the data from.
An up-to-date list of supported exchanges and their IDs can be obtained
with the \code{\link[=supported_exchanges]{supported_exchanges()}} function.}

\item{max_attempts}{(double, positive): specifies the
maximum number of attempts to call the CoinGecko API (e.g., if
the first call fails for some reason). Additional attempts are
implemented with an exponential backoff. Defaults to 3.}
}
\value{
A tibble with the following columns:
\itemize{
\item \code{exchange_id} (character): same as the argument \code{exchange_id};
\item \code{exchange_name} (character): common name of the exchange;
\item \code{coin_id} (character): same as the argument \code{coin_id};
\item \code{name} (character): common name of the coin;
\item \code{base} (character): symbol of the base currency in a trading pair;
\item \code{target} (character): symbol of the target currency in a trading pair;
\item \code{trust_score} (character): trust score of the trading pair (\code{"green"},
\code{"yellow"}, \code{"red"}; see \href{https://blog.coingecko.com/trust-score/}{this} and
\href{https://blog.coingecko.com/trust-score-2/}{this} article on the CoinGecko
website for details);
\item \code{last_price} (double): last price reported by this exchange for this
trading pair;
\item \code{last_fetch_at} (POSIXct, UTC time zone): timestamp of when \code{last_price}
was recorded;
\item \code{last_traded_at} (POSIXct, UTC time zone): timestamp of the most recent
trade;
\item \code{bid_ask_spread_percentage} (double): percentage difference between
the ask price (lowest price a seller is willing to sell for) and the bid price
(highest price a buyer is willing to buy for; see
\href{https://www.investopedia.com/terms/b/bid-askspread.asp}{Investopedia} for
details);
\item \code{trading_volume_24h} (double): trading volume (in \code{target} currency)
recorded in the last 24 h (as of \code{last_traded_at});
\item \code{last_price_btc} (double): last price reported by this exchange for this
coin, expressed in Bitcoin;
\item \code{last_price_eth} (double): last price reported by this exchange for this
coin, expressed in Ethereum;
\item \code{last_price_usd} (double): last price reported by this exchange for this
coin, expressed in US dollar;
\item \code{trading_volume_24h_btc} (double): 24 hours trading volume expressed in
Bitcoin (as of \code{last_traded_at});
\item \code{trading_volume_24h_eth} (double): 24 hours trading volume expressed in
Ethereum;
\item \code{trading_volume_24h_usd} (double): 24 hours trading volume expressed in
US dollars;
\item \code{cost_to_move_up_2percent_usd} and \code{cost_to_move_down_2percent_usd}
(double): 2\% market depth (see
\href{https://blog.coingecko.com/trust-score/}{this} article on the CoinGecko
website for details);
\item \code{is_anomaly} (logical): an indicator of whether the ticker's price is an
outlier (see "Outlier detection" in
\href{https://www.coingecko.com/en/methodology}{Methodology} on the GoinGecko
website);
\item \code{is_stale} (logical): an indicator of whether the ticker's price has not
been updated for a while (see "Outlier detection" in
\href{https://www.coingecko.com/en/methodology}{Methodology} on the GoinGecko
website);
\item \code{trade_url} (character): URL to this trading pair's page.
}
}
\description{
Retrieves the most recent exchange tickers for a coin
}
\details{
This function is based on the public
\href{https://www.coingecko.com/api/documentations/v3}{CoinGecko API},
which has a limit of 50 calls per minute. Please
keep this limit in mind when developing your applications.
}
\examples{
\donttest{
r <- coin_tickers(coin_id = "cardano", exchange_id = "binance")
print(r)
}
}
