% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\docType{methods}
\name{roots}
\alias{roots}
\alias{roots,geex-method}
\alias{roots,geex,geex-method}
\alias{roots,geex_summary-method}
\alias{roots,geex,geex-method}
\title{Gets the parameter estimates matrix from a geex object}
\usage{
roots(object, ...)

\S4method{roots}{geex}(object)

\S4method{roots}{geex_summary}(object)
}
\arguments{
\item{object}{a \code{\linkS4class{geex}} object}

\item{...}{arguments passed to other methods}
}
\description{
Gets the parameter estimates matrix from a geex object
}
\examples{
ex_eeFUN <- function(data){
 function(theta){
   with(data,
    c(Y1 - theta[1],
     (Y1 - theta[1])^2 - theta[2] ))
}}

results <- m_estimate(
 estFUN = ex_eeFUN,
 data  = geexex,
 root_control = setup_root_control(start = c(1,1)))

roots(results)
}
