`negloglike` <-
function(theta, data)
{
	#----------------------------------
	#-----       PARSE DATA       -----
	#----------------------------------
	design 		<- data$design			# Model Secification
	y			<- data$obs				# TIP data
	Sigma		<- data$vcv				# Variance-Covariance Matrix
	tree.matrix <- data$tree.matrix		# Branch length matrix (for Kappa fit)
	spp.name 	<- data$spp.name        # Spp names of TIP data
	#----------------------------------
	#-----  DETERMINE OTHER INFO  -----
	#----------------------------------
	spp.vcv 	<- rownames(data$vcv)   # SPP names
	n			<- length(y)
	bounds		<- design$bounds
	model		<- design$model			
	if (sum(names(model)==c("lambda", "kappa", "delta"))!=3)
		stop("Error with \"model\" internal paramter")
	#------ INTERNAL CONSISTENCY CHECK  -------
	if (sum(spp.name == spp.vcv) != n)
		stop("Data and VCV out of order")
	#----------------------------------
	#-----       DEFAULT FIT      -----
	#----------------------------------
	if (sum(model)==0) {
		mu		<-	theta[1]
		beta	<-  inv.logit(theta[2], min=bounds$beta[1], max=bounds$beta[2])
		means	<- 	rep(mu,n)
		#---- RETURN NEGLOGLIKELIHOOD ---
		return( -dmvnorm(y,means,beta*Sigma, log=TRUE))
	#----------------------------------
	#-----       LAMBDA ONLY      -----
	#----------------------------------
	} else if (model[1] & !(model[2] | model[3])){
		mu		<-	theta[1]
		beta	<-  inv.logit(theta[2], min=bounds$beta[1], max=bounds$beta[2])
		lambda	<- 	inv.logit(theta[3], min=bounds$lambda[1], max=bounds$lambda[2])
		#---- multiply off diagonals
		index			<-	matrix(TRUE, n,n)
		diag(index)		<- FALSE
		Sigma[index] 	<- Sigma[index]*lambda
		means		    <- rep(mu,n)
		#---- RETURN NEGLOGLIKELIHOOD ---
		return( -dmvnorm(y,means,beta*Sigma, log=TRUE))
	#----------------------------------
	#-----        KAPPA ONLY      -----
	#----------------------------------
	} else if (model[2] & !(model[1] | model[3])){
		beta.bound 	 <- bounds$beta
		kappa.bound  <- bounds$kappa
		mu		<-	theta[1]
		beta	<-  inv.logit(theta[2], min=bounds$beta[1], max=bounds$beta[2])
		kappa	<- 	inv.logit(theta[3], min=bounds$kappa[1], max=bounds$kappa[2])
		if (kappa==0)
			stop("kappa = 0, procedure haulted")
		#---- RAISE BRANCH LENGTHS BY KAPPA
		tree.matrix<-tree.matrix^kappa     
		#---- DETERMINE VCV
		Sigma <- tree.matrix %*% t(tree.matrix)   
		means	<- 	rep(mu,n)
		#---- RETURN NEGLOGLIKELIHOOD ---
		return( -dmvnorm(y,means,beta*Sigma, log=TRUE))
	#----------------------------------
	#-----        DELTA ONLY      -----
	#----------------------------------	
	} else if (model[3] & !(model[1] | model[2])){
		mu		<-	theta[1]
		beta	<-  inv.logit(theta[2], min=bounds$beta[1], max=bounds$beta[2])
		delta	<-  inv.logit(theta[3], min=bounds$delta[1], max=bounds$delta[2])
		means	<- rep(mu,n)
		#---- DELTA TRANSFORMATION
		Sigma	<- data$vcv^delta
		rescale <- max(data$vcv)/max(Sigma)
		Sigma	<-(Sigma*rescale)
		#---- RETURN NEGLOGLIKELIHOOD ---
		return( -dmvnorm(y,means,beta*Sigma, log=TRUE))
	#----------------------------------
	#-----        ALPHA ONLY      -----
	#----------------------------------			
	} else if (model[4] & !(model[1] | model[2] | model[3])){
		mu		<-	theta[1]
		beta	<-  inv.logit(theta[2], min=bounds$beta[1], max=bounds$beta[2])
		alpha	<-  inv.logit(theta[3], min=bounds$alpha[1], max=bounds$alpha[2])
		weights<-matrix(nrow=length(data$obs), ncol=2)
		weights[,1]<-exp(-alpha*data$vcv[1,1])
		weights[,2]<-exp(-alpha*data$vcv[1,1])*beta2*(exp(alpha*data$vcv[1,1])-1)
		means	<- weights %*% c(mu, mu2)
		#---- DELTA TRANSFORMATION
		Sigma	<- ou.vcv(data$vcv, alpha, beta)
	
		#---- RETURN NEGLOGLIKELIHOOD ---
		return( -dmvnorm(y,means,beta*Sigma, log=TRUE))
	}else{
		stop("Parameters  \"lambda, \"kappa\" and \"delta\" can only be fit one at a time currently")
	}
}


ou.vcv<-function (phy, node = NULL, alpha, sigma2) 
{
    if (class(phy) != "phylo") 
        stop("object \"phy\" is not of class \"phylo\".")
       nb.tip <- length(phy$tip.label)
    root <- nb.tip + 1
    if (is.null(node)) 
        node <- numeric(0)
    if (root %in% node) 
        node <- node[node != root]
    bt <- branching.times(phy)
    Tmax <- bt[1]
    Wend <- matrix(0, nb.tip, length(node) + 1)
    colnames(Wend) <- c(names(sort(bt[node])), as.character(root))
    Wstart <- Wend
    Wstart[, ncol(Wstart)] <- Tmax
    root2tip <- .Call("seq_root2tip", phy$edge[, 1], phy$edge[, 
        2], nb.tip, phy$Nnode, PACKAGE = "ape")
    for (i in 1:nb.tip) {
        last.change <- names(Tmax)
        for (j in root2tip[[i]]) {
            if (j %in% node) {
                jb <- as.character(j)
                Wend[i, last.change] <- Wstart[i, jb] <- bt[jb]
                last.change <- jb
            }
        }
    }
    W <- cophenetic.phylo(phy)
   	s<-Tmax-W/2
    V <- (sigma2/(2*alpha))*
    exp(-2*alpha * (Tmax-s)) * 
    (1 - exp(-2 * alpha * s))
	V
}
