% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/gelnet.R
\name{gelnet.L1bin}
\alias{gelnet.L1bin}
\title{A GELnet model with a requested number of non-zero weights}
\usage{
gelnet.L1bin(f.gelnet, nF, l1s, max.iter = 10)
}
\arguments{
\item{f.gelnet}{a function that accepts one parameter: L1 penalty value,
and returns a typical GELnets model (list with w and b as its entries)}

\item{nF}{the desired number of non-zero features}

\item{l1s}{the right side of the search interval: search will start in [0, l1s]}

\item{max.iter}{the maximum number of iterations of the binary search}
}
\value{
The model with the desired number of non-zero weights and the corresponding value of the
L1-norm parameter. Returned as a list with three elements:
\describe{
  \item{w}{p-by-1 vector of p model weights}
  \item{b}{scalar, bias term for the linear model}
  \item{l1}{scalar, the corresponding value of the L1-norm parameter}
}
}
\description{
Binary search to find an L1 penalty parameter value that yields the desired
  number of non-zero weights in a GELnet model
}
\details{
The method performs simple binary search starting in [0, l1s] and iteratively
training a model using the provided \code{f.gelnet}. At each iteration, the
method checks if the number of non-zero weights in the model is higher or lower
than the requested \code{nF} and adjusts the value of the L1 penalty term accordingly.
For linear regression problems, it is recommended to initialize \code{l1s} to the output
of \code{L1.ceiling}.
}
\examples{
X <- matrix( rnorm(100*20), 100, 20 )
y <- rnorm(100)
l1s <- L1.ceiling( X, y )
f <- function( l1 ) {gelnet.lin( X, y, l1, l2 = 1 )}
m <- gelnet.L1bin( f, nF = 50, l1s = l1s )
print( m$l1 )
}
\seealso{
L1.ceiling
}

