/*
 * Decompiled with CFR 0.152.
 */
package org.drugis.mtc.model;

import org.apache.commons.collections15.Transformer;
import org.drugis.mtc.data.DataType;
import org.drugis.mtc.model.Measurement;
import org.drugis.mtc.model.Network;
import org.drugis.mtc.model.NetworkBuilder;
import org.drugis.mtc.model.Treatment;

public class ContinuousNetworkBuilder<TreatmentType>
extends NetworkBuilder<TreatmentType> {
    public static ContinuousNetworkBuilder<Treatment> createSimple() {
        return new ContinuousNetworkBuilder<Treatment>(new NetworkBuilder.TreatmentIdTransformer(), new NetworkBuilder.TreatmentDescriptionTransformer());
    }

    public ContinuousNetworkBuilder() {
        super(DataType.CONTINUOUS);
    }

    public ContinuousNetworkBuilder(Transformer<TreatmentType, String> treatmentToIdString, Transformer<TreatmentType, String> treatmentToDescription) {
        super(treatmentToIdString, treatmentToDescription, DataType.CONTINUOUS);
    }

    @Override
    public Network buildNetwork() {
        Network network = super.buildNetwork();
        return network;
    }

    public void add(String studyId, TreatmentType treatmentId, double mean, double stdDev, int sampleSize) {
        Treatment t = this.makeTreatment(treatmentId);
        this.add(studyId, t, new Measurement(t, mean, stdDev, sampleSize));
    }
}

