/*
 * Decompiled with CFR 0.152.
 */
package gov.lanl.yadas;

import gov.lanl.yadas.MCMCInput;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class DataFrame
implements MCMCInput {
    int n;
    int mi;
    int md;
    int ms;
    String[] varnames;
    double[][] realvars;
    int[][] intvars;
    String[][] stringvars;
    String delimiter = "|";

    public DataFrame(String filename) {
        this(filename, "|");
    }

    public DataFrame(String filename, String delimiter) {
        this.delimiter = delimiter;
        try {
            BufferedReader in = new BufferedReader(new FileReader(filename));
            String s = in.readLine();
            this.n = Integer.parseInt(s);
            ArrayList<String> tempvarnames = new ArrayList<String>();
            s = in.readLine();
            StringTokenizer t = new StringTokenizer(s, delimiter);
            int j = 0;
            while (t.hasMoreTokens()) {
                tempvarnames.add(t.nextToken());
                ++j;
            }
            int m = j;
            this.varnames = new String[m];
            s = in.readLine();
            t = new StringTokenizer(s, delimiter);
            char[] vartypes = new char[m];
            for (int ii = 0; ii < m; ++ii) {
                vartypes[ii] = t.nextToken().charAt(0);
            }
            String[] intnames = new String[m];
            String[] realnames = new String[m];
            String[] stringnames = new String[m];
            this.ms = 0;
            this.md = 0;
            this.mi = 0;
            block14: for (int ii = 0; ii < m; ++ii) {
                switch (vartypes[ii]) {
                    case 'i': {
                        intnames[this.mi] = (String)tempvarnames.get(ii);
                        ++this.mi;
                        continue block14;
                    }
                    case 'd': 
                    case 'f': 
                    case 'r': {
                        realnames[this.md] = (String)tempvarnames.get(ii);
                        ++this.md;
                        continue block14;
                    }
                    case 's': {
                        stringnames[this.ms] = (String)tempvarnames.get(ii);
                        ++this.ms;
                        continue block14;
                    }
                    default: {
                        System.out.println("Input file had an unknown variable type.");
                    }
                }
            }
            System.arraycopy(intnames, 0, this.varnames, 0, this.mi);
            System.arraycopy(realnames, 0, this.varnames, this.mi, this.md);
            System.arraycopy(stringnames, 0, this.varnames, this.mi + this.md, this.ms);
            this.intvars = new int[this.mi][this.n];
            this.realvars = new double[this.md][this.n];
            this.stringvars = new String[this.ms][this.n];
            String[][] tempvars = new String[m][this.n];
            boolean more = true;
            for (int k = 0; k < this.n && more; ++k) {
                s = in.readLine();
                if (s == null) {
                    more = false;
                    continue;
                }
                t = new StringTokenizer(s, delimiter);
                for (int i = 0; i < m; ++i) {
                    tempvars[i][k] = t.nextToken();
                }
            }
            int ni = 0;
            int nd = 0;
            int ns = 0;
            block17: for (int ii = 0; ii < m; ++ii) {
                switch (vartypes[ii]) {
                    case 'i': {
                        int l;
                        for (l = 0; l < this.n; ++l) {
                            this.intvars[ni][l] = Integer.parseInt(tempvars[ii][l]);
                        }
                        ++ni;
                        continue block17;
                    }
                    case 'd': 
                    case 'f': 
                    case 'r': {
                        int l;
                        for (l = 0; l < this.n; ++l) {
                            this.realvars[nd][l] = Double.parseDouble(tempvars[ii][l]);
                        }
                        ++nd;
                        continue block17;
                    }
                    case 's': {
                        System.arraycopy(tempvars[ii], 0, this.stringvars[ns], 0, this.n);
                        ++ns;
                        continue block17;
                    }
                }
            }
        }
        catch (IOException e) {
            System.out.print("Error: " + e);
            System.exit(1);
        }
    }

    public int length() {
        return this.n;
    }

    public int getVariableLength() {
        return this.n;
    }

    public double[][] getRealvars() {
        double[][] temp = new double[this.md][this.n];
        for (int ii = 0; ii < this.md; ++ii) {
            System.arraycopy(this.realvars[ii], 0, temp[ii], 0, this.n);
        }
        return temp;
    }

    public int[][] getIntvars() {
        int[][] temp = new int[this.mi][this.n];
        for (int ii = 0; ii < this.mi; ++ii) {
            System.arraycopy(this.intvars[ii], 0, temp[ii], 0, this.n);
        }
        return temp;
    }

    public String[][] getStringvars() {
        String[][] temp = new String[this.ms][this.n];
        for (int ii = 0; ii < this.ms; ++ii) {
            System.arraycopy(this.stringvars[ii], 0, temp[ii], 0, this.n);
        }
        return temp;
    }

    public double[] r(String varname) {
        int ii;
        for (ii = this.mi; ii < this.mi + this.md && !varname.equals(this.varnames[ii]); ++ii) {
        }
        if (ii == this.mi + this.md) {
            System.out.println("No variable by the name " + varname);
            System.exit(1);
        }
        double[] temp = new double[this.n];
        System.arraycopy(this.realvars[ii - this.mi], 0, temp, 0, this.n);
        return temp;
    }

    public double[] r(String varname, int numcopies) {
        int ii;
        for (ii = this.mi; ii < this.mi + this.md && !varname.equals(this.varnames[ii]); ++ii) {
        }
        if (ii == this.mi + this.md) {
            System.out.println("No variable by the name " + varname);
            System.exit(1);
        }
        double[] temp = new double[this.n * numcopies];
        for (int jj = 0; jj < numcopies; ++jj) {
            System.arraycopy(this.realvars[ii - this.mi], 0, temp, jj * this.n, this.n);
        }
        return temp;
    }

    public double[] r(double val) {
        double[] temp = new double[this.n];
        for (int ii = 0; ii < this.n; ++ii) {
            temp[ii] = val;
        }
        return temp;
    }

    public static double[] r(double val, int len) {
        double[] temp = new double[len];
        for (int ii = 0; ii < len; ++ii) {
            temp[ii] = val;
        }
        return temp;
    }

    public int[] i(String varname) {
        int ii;
        for (ii = 0; ii < this.mi && !varname.equals(this.varnames[ii]); ++ii) {
        }
        if (ii == this.mi) {
            System.out.println("No variable by the name " + varname);
            System.exit(1);
        }
        int[] temp = new int[this.n];
        System.arraycopy(this.intvars[ii], 0, temp, 0, this.n);
        return temp;
    }

    public int[] i(int val) {
        int[] temp = new int[this.n];
        for (int ii = 0; ii < this.n; ++ii) {
            temp[ii] = val;
        }
        return temp;
    }

    public static int[] i(int val, int len) {
        int[] temp = new int[len];
        for (int ii = 0; ii < len; ++ii) {
            temp[ii] = val;
        }
        return temp;
    }

    public String[] s(String varname) {
        int ii;
        for (ii = this.mi + this.md; ii < this.mi + this.md + this.ms && !varname.equals(this.varnames[ii]); ++ii) {
        }
        if (ii == this.mi + this.md + this.ms) {
            System.out.println("No variable by the name " + varname);
            System.exit(1);
        }
        String[] temp = new String[this.n];
        System.arraycopy(this.stringvars[ii - this.mi - this.md], 0, temp, 0, this.n);
        return temp;
    }

    public int[] findRealVars(String firstchar) {
        int ii;
        int count = 0;
        for (ii = this.mi; ii < this.mi + this.md; ++ii) {
            if (!this.varnames[ii].substring(0, firstchar.length()).equals(firstchar)) continue;
            ++count;
        }
        if (count == 0) {
            System.out.println("No real variables in the data frame match the requested pattern");
            System.exit(1);
        }
        int[] outvec = new int[count];
        for (ii = this.mi; ii < this.mi + this.md; ++ii) {
            if (!this.varnames[ii].substring(0, firstchar.length()).equals(firstchar)) continue;
            outvec[outvec.length - count--] = ii - this.mi;
        }
        return outvec;
    }

    public int findVar(String varname) {
        int ii;
        for (ii = 0; ii < this.mi + this.md + this.ms && !varname.equals(this.varnames[ii]); ++ii) {
        }
        if (ii == this.mi + this.md + this.ms) {
            return -1;
        }
        if (ii < this.mi) {
            return ii;
        }
        if (ii < this.mi + this.md) {
            return ii - this.mi;
        }
        return ii - this.mi - this.md;
    }

    public int findRealVar(String varname) {
        int ii;
        for (ii = this.mi; ii < this.mi + this.md && !varname.equals(this.varnames[ii]); ++ii) {
        }
        if (ii == this.mi + this.md) {
            System.out.println("No variable by the name " + varname);
            System.exit(1);
        }
        return ii - this.mi;
    }

    public int findIntVar(String varname) {
        int ii;
        for (ii = 0; ii < this.mi && !varname.equals(this.varnames[ii]); ++ii) {
        }
        if (ii == this.mi) {
            System.out.println("No variable by the name " + varname);
            System.exit(1);
        }
        return ii;
    }

    public int findStringVar(String varname) {
        int ii;
        for (ii = this.mi + this.md; ii < this.mi + this.md + this.ms && !varname.equals(this.varnames[ii]); ++ii) {
        }
        if (ii == this.mi + this.md + this.ms) {
            System.out.println("No variable by the name " + varname);
            System.exit(1);
        }
        return ii - this.mi - this.md;
    }

    public int[] u() {
        int[] temp = new int[this.n];
        for (int ii = 0; ii < this.n; ++ii) {
            temp[ii] = ii;
        }
        return temp;
    }

    public static int[] u(int len) {
        int[] temp = new int[len];
        for (int ii = 0; ii < len; ++ii) {
            temp[ii] = ii;
        }
        return temp;
    }

    public static int[] u(int len, int numcopies) {
        int[] temp = new int[len * numcopies];
        int ind = 0;
        for (int jj = 0; jj < numcopies; ++jj) {
            int ii = 0;
            while (ii < len) {
                temp[ind] = ii++;
                ++ind;
            }
        }
        return temp;
    }

    public static int[] u_offset(int len, int start) {
        int[] temp = new int[len];
        for (int ii = start; ii < len + start; ++ii) {
            temp[ii - start] = ii;
        }
        return temp;
    }

    public static void main(String[] args) {
        System.out.print("Testing DataFrame.\n");
        DataFrame df = new DataFrame("c:/hamada/java/yadasExamples/mshDegradYThetalm.txt");
        System.out.println(df.varnames[0] + df.varnames[1] + df.varnames[80]);
        System.out.println("n: " + df.n + " mi: " + df.mi + " md: " + df.md + " ms: " + df.ms);
        System.out.println("1" + df.realvars[0][0]);
        System.out.println("2" + df.realvars[80][399]);
        double[] one = df.r("x80");
        System.out.println(one.length);
        System.out.println("one: " + one[0] + "|" + one[1] + "|" + one[2] + "|" + one[3] + "|" + one[399]);
        double[] y = df.r("y");
        System.out.println(y.length);
        System.out.println("y: " + y[0] + "|" + y[1] + "|" + y[2] + "|" + y[3] + "|" + y[399]);
        System.exit(0);
    }
}

