/*
 * Decompiled with CFR 0.152.
 */
package gov.lanl.yadas;

import gov.lanl.yadas.MCMCUpdate;
import gov.lanl.yadas.TunableMCMCUpdate;

public class UpdateTuner
implements MCMCUpdate {
    private TunableMCMCUpdate upd;
    private double[] sss;
    private int numsizes;
    private int numits;
    private int numcycles;
    private int itno = 0;
    private double probtarget = Math.exp(-1.0);
    public int nrit = 50;
    public double radix = 2.0;
    private int[] successes;
    private int[] trials;
    private double[][] css;
    private int[][] accmat;
    private boolean done = false;
    private int[] oldacc;
    private boolean b_fixed = true;
    private double mua = -3.0;
    private double sigmaa = 5.0;

    public UpdateTuner(TunableMCMCUpdate upd) {
        this(upd, upd.getStepSizes(), 13, 50, 1, Math.exp(-1.0), true, -3.0, 5.0);
    }

    public UpdateTuner(TunableMCMCUpdate upd, int numbsizes, int numits, int numcycles, double probtarget) {
        this(upd, upd.getStepSizes(), numbsizes, numits, numcycles, probtarget, true, -3.0, 5.0);
    }

    public UpdateTuner(TunableMCMCUpdate upd, double[] sss, int numbsizes, int numits, int numcycles, double probtarget) {
        this(upd, sss, numbsizes, numits, numcycles, probtarget, true, -3.0, 5.0);
    }

    public UpdateTuner(TunableMCMCUpdate upd, double[] sss, int numbsizes, int numits, int numcycles, double probtarget, boolean b_fixed, double mua, double sigmaa) {
        this.upd = upd;
        this.sss = sss;
        this.numsizes = numbsizes;
        this.numits = numits;
        this.numcycles = numcycles;
        this.probtarget = probtarget;
        this.b_fixed = b_fixed;
        this.mua = mua;
        this.sigmaa = sigmaa;
        this.numsizes += this.numsizes % 2 == 1 ? 0 : 1;
        this.css = new double[this.numsizes][sss.length];
        this.accmat = new int[this.numsizes][sss.length];
        this.oldacc = new int[sss.length];
        int os = this.numsizes / 2;
        for (int i = 0; i < this.numsizes; ++i) {
            for (int j = 0; j < sss.length; ++j) {
                this.css[i][j] = sss[j] * Math.pow(this.radix, i - os);
                this.accmat[i][j] = 0;
            }
        }
        for (int j = 0; j < sss.length; ++j) {
            this.oldacc[j] = 0;
        }
    }

    public void update() {
        int which = this.itno % this.numsizes;
        if (!this.done) {
            if (this.itno == this.numsizes * this.numits) {
                this.done = true;
                int[] xvec = new int[this.numsizes];
                double[] svec = new double[this.numsizes];
                double[] temp = new double[this.sss.length];
                for (int j = 0; j < this.sss.length; ++j) {
                    if (this.sss[j] == 0.0) continue;
                    for (int i = 0; i < this.numsizes; ++i) {
                        xvec[i] = this.accmat[i][j];
                        svec[i] = this.css[i][j];
                    }
                    double[] ttemp = UpdateTuner.nrlogist(xvec, this.numits, svec, this.nrit, this.b_fixed, this.mua, this.sigmaa);
                    temp[j] = Math.exp((Math.log(this.probtarget / (1.0 - this.probtarget)) - ttemp[0]) / ttemp[1]);
                    this.upd.setStepSize(temp[j], j);
                }
                this.upd.tuneoutput();
            } else {
                this.upd.setStepSizes(this.css[which]);
            }
        }
        this.upd.update();
        if (!this.done) {
            int[] acc = this.upd.acceptances();
            for (int j = 0; j < acc.length; ++j) {
                int[] nArray = this.accmat[which];
                int n = j;
                nArray[n] = nArray[n] + (acc[j] - this.oldacc[j]);
            }
            System.arraycopy(acc, 0, this.oldacc, 0, acc.length);
        }
        ++this.itno;
    }

    public static String expandvec(int[] vec) {
        String out = "";
        for (int i = 0; i < vec.length; ++i) {
            out = out + vec[i] + "|";
        }
        return out;
    }

    public static String expandvec(double[] vec) {
        String out = "";
        for (int i = 0; i < vec.length; ++i) {
            out = out + vec[i] + "|";
        }
        return out;
    }

    public String accepted() {
        return this.upd.accepted();
    }

    public void updateoutput() {
        this.upd.updateoutput();
    }

    public void finish() {
        this.upd.finish();
    }

    public double[] getStepSizes() {
        return this.upd.getStepSizes();
    }

    public void setStepSize(double s, int i) {
        this.upd.setStepSize(s, i);
    }

    public void setStepSizes(double[] s) {
        this.upd.setStepSizes(s);
    }

    public static double[] nrlogist(int[] x, int n, double[] es, int nrit, boolean b_fixed, double mua, double sigmaa) {
        int[] nv = new int[x.length];
        for (int i = 0; i < x.length; ++i) {
            nv[i] = n;
        }
        return UpdateTuner.nrlogist(x, nv, es, nrit, b_fixed, mua, sigmaa);
    }

    public static double[] nrlogist(int[] x, int[] n, double[] es, int nrit, boolean b_fixed, double mua, double sigmaa) {
        double[] out;
        double test;
        if (b_fixed && !Double.isInfinite(test = Math.exp(-(out = UpdateTuner.nrlogist_b_fixed(x, n, es, nrit, mua, sigmaa))[0] / out[1])) & !Double.isNaN(test)) {
            return out;
        }
        return UpdateTuner.nrlogist_b_estimated(x, n, es, nrit, mua, sigmaa);
    }

    public static double[] nrlogist_b_fixed(int[] x, int[] n, double[] es, int nrit, double mua, double sigmaa) {
        double a = 0.0;
        double b = -1.12145;
        double[] npobs = new double[x.length];
        double[] nphat = new double[x.length];
        double[] np1p = new double[x.length];
        double[] s = new double[x.length];
        for (int i = 0; i < x.length; ++i) {
            npobs[i] = (double)x[i] + 0.0;
            s[i] = Math.log(es[i]);
        }
        for (int k = 0; k < nrit; ++k) {
            for (int i = 0; i < x.length; ++i) {
                nphat[i] = (double)n[i] / (1.0 + Math.exp(-a - b * s[i]));
                np1p[i] = nphat[i] * (1.0 - nphat[i] / (double)n[i]);
            }
            a += (UpdateTuner.sum(npobs) - UpdateTuner.sum(nphat) - (a - mua) / sigmaa / sigmaa) / (UpdateTuner.sum(np1p) + 1.0 / sigmaa / sigmaa);
        }
        return new double[]{a, b};
    }

    public static double[] nrlogist_b_estimated(int[] x, int[] n, double[] es, int nrit, double mua, double sigmaa) {
        double a = 0.0;
        double b = 0.0;
        double A = 0.0;
        double B = 0.0;
        double C = 0.0;
        double dev0 = 0.0;
        double dev1 = 0.0;
        double[] phat = new double[x.length];
        double[] s = new double[x.length];
        for (int i = 0; i < x.length; ++i) {
            s[i] = Math.log(es[i]);
        }
        for (int k = 0; k < nrit; ++k) {
            dev1 = 0.0;
            dev0 = 0.0;
            C = 0.0;
            B = 0.0;
            A = 0.0;
            for (int i = 0; i < x.length; ++i) {
                phat[i] = 1.0 / (1.0 + Math.exp(-a - b * s[i]));
                A += (double)n[i] * phat[i] * (1.0 - phat[i]);
                B += (double)n[i] * s[i] * phat[i] * (1.0 - phat[i]);
                C += (double)n[i] * s[i] * s[i] * phat[i] * (1.0 - phat[i]);
                dev0 += (double)x[i] + 0.0 - ((double)n[i] + 0.0) * phat[i];
                dev1 += s[i] * ((double)x[i] + 0.0 - ((double)n[i] + 0.0) * phat[i]);
            }
            a += (C * dev0 - B * dev1) / (A * C - B * B);
            b += (-B * dev0 + A * dev1) / (A * C - B * B);
        }
        return new double[]{a, b};
    }

    public static double sum(double[] x) {
        double out = 0.0;
        for (int i = 0; i < x.length; ++i) {
            out += x[i];
        }
        return out;
    }

    public static void main(String[] args) {
        double[] ttemp = UpdateTuner.nrlogist(new int[]{32, 31, 35, 28, 13, 9, 5, 3, 0, 0, 0, 0, 1}, new int[]{50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50}, new double[]{0.00625, 0.0125, 0.025, 0.05, 0.1, 0.2, 0.4, 0.8, 1.6, 3.2, 6.4, 12.8, 25.6}, 50, true, -3.0, 5.0);
        System.out.println(" a = " + ttemp[0] + ", b = " + ttemp[1]);
    }
}

