/*
 * Decompiled with CFR 0.152.
 */
package org.drugis.common.threading.status;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.drugis.common.threading.Task;
import org.drugis.common.threading.TaskListener;
import org.drugis.common.threading.event.PhaseEvent;
import org.drugis.common.threading.event.TaskEvent;
import org.drugis.common.threading.event.TaskProgressEvent;
import org.drugis.common.threading.status.AbstractProgressModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskProgressModel
extends AbstractProgressModel {
    private Map<Task, Double> d_phaseProgress = new HashMap<Task, Double>();
    List<Task> d_phases = new ArrayList<Task>();
    private PhaseListener d_phaseListener = new PhaseListener();
    private Object d_lock = new Object();
    private TaskListener d_taskListener = new PhaseTaskListener();

    public TaskProgressModel(Task task) {
        this.setTask(task);
    }

    public void setTask(Task task) {
        if (this.d_task != null) {
            this.d_task.removeTaskListener(this.d_taskListener);
        }
        this.d_task = task;
        if (task.isFinished()) {
            this.setProgress(1.0);
        }
        this.removePhases();
        this.setDeterminate(task.isFinished());
        task.addTaskListener(this.d_taskListener);
    }

    public Task getTask() {
        return this.d_task;
    }

    private void removePhases() {
        for (Task t : this.d_phases) {
            t.removeTaskListener(this.d_phaseListener);
        }
        this.d_phases.clear();
        this.d_phaseProgress.clear();
    }

    @Override
    protected boolean calcDeterminate() {
        if (this.d_phases.isEmpty()) {
            return false;
        }
        for (Task p : this.d_phases) {
            if (this.d_phaseProgress.get(p) != null) continue;
            return false;
        }
        return true;
    }

    @Override
    protected Double calcProgress() {
        HashSet<Double> values = new HashSet<Double>(this.d_phaseProgress.values());
        values.remove(null);
        if (!values.isEmpty()) {
            return Collections.min(values);
        }
        return 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<String> getPhaseStrings() {
        ArrayList<String> phaseStrings = new ArrayList<String>();
        Object object = this.d_lock;
        synchronized (object) {
            for (Task p : this.d_phases) {
                phaseStrings.add(p.toString() + ": " + this.formatProgress(this.d_phaseProgress.get(p)));
            }
        }
        return phaseStrings;
    }

    protected class PhaseTaskListener
    implements TaskListener {
        protected PhaseTaskListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void taskEvent(TaskEvent e) {
            Object object = TaskProgressModel.this.d_lock;
            synchronized (object) {
                TaskEvent.EventType type = e.getType();
                if (type.equals((Object)TaskEvent.EventType.TASK_STARTED)) {
                    TaskProgressModel.this.setProgress(0.0);
                } else if (type.equals((Object)TaskEvent.EventType.TASK_PROGRESS)) {
                    TaskProgressModel.this.setDeterminate(true);
                    TaskProgressModel.this.setProgress(TaskProgressModel.this.calcProgress((TaskProgressEvent)e));
                } else if (type.equals((Object)TaskEvent.EventType.TASK_FINISHED)) {
                    TaskProgressModel.this.setDeterminate(true);
                    TaskProgressModel.this.setProgress(1.0);
                } else if (type.equals((Object)TaskEvent.EventType.TASK_FAILED)) {
                    TaskProgressModel.this.setDeterminate(true);
                    TaskProgressModel.this.setProgress(0.0);
                } else if (type.equals((Object)TaskEvent.EventType.TASK_ABORTED)) {
                    TaskProgressModel.this.setDeterminate(true);
                    TaskProgressModel.this.setProgress(0.0);
                } else if (type.equals((Object)TaskEvent.EventType.TASK_RESTARTED)) {
                    TaskProgressModel.this.setDeterminate(true);
                    TaskProgressModel.this.setProgress(0.0);
                } else if (e instanceof PhaseEvent) {
                    PhaseEvent evt = (PhaseEvent)e;
                    Task phase = evt.getPhase();
                    if (type.equals((Object)TaskEvent.EventType.PHASE_STARTED)) {
                        TaskProgressModel.this.d_phases.add(phase);
                        phase.addTaskListener(TaskProgressModel.this.d_phaseListener);
                        TaskProgressModel.this.d_phaseProgress.put(phase, null);
                    } else if (type.equals((Object)TaskEvent.EventType.PHASE_FINISHED)) {
                        phase.removeTaskListener(TaskProgressModel.this.d_phaseListener);
                        TaskProgressModel.this.d_phaseProgress.remove(phase);
                        TaskProgressModel.this.d_phases.remove(phase);
                    }
                    TaskProgressModel.this.setDeterminate(TaskProgressModel.this.calcDeterminate());
                    TaskProgressModel.this.setProgress(TaskProgressModel.this.calcProgress());
                }
            }
        }
    }

    private final class PhaseListener
    implements TaskListener {
        private PhaseListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void taskEvent(TaskEvent event) {
            Object object = TaskProgressModel.this.d_lock;
            synchronized (object) {
                if (event.getType().equals((Object)TaskEvent.EventType.TASK_PROGRESS)) {
                    TaskProgressModel.this.d_phaseProgress.put(event.getSource(), TaskProgressModel.this.calcProgress((TaskProgressEvent)event));
                    TaskProgressModel.this.setDeterminate(TaskProgressModel.this.calcDeterminate());
                    TaskProgressModel.this.setProgress(TaskProgressModel.this.calcProgress());
                }
            }
        }
    }
}

